/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.pace.PaceInputEstablishChannel;
import de.intarsys.tr3110.pace.PaceOutputEstablishChannel;
import java.io.IOException;
import java.util.Arrays;

public interface IPaceApplication
extends ICardApplication {
    public static final int PINID_MRZ = 1;
    public static final int PINID_CAN = 2;
    public static final int PINID_PIN = 3;
    public static final int PINID_PUK = 4;
    public static final byte[] DD_AUTHENTICATION_TERMINAL = new byte[]{0, 0, 0, 1, 16};
    public static final byte[] DD_INSPECTION_SYSTEM = new byte[]{3};
    public static final byte[] DD_SIGNATURE_TERMINAL = new byte[]{3};

    public void destroyPaceChannel() throws CardApplicationException;

    public PaceOutputEstablishChannel establishPaceChannel(PaceInputEstablishChannel var1) throws CardApplicationException;

    public boolean isNative();

    public boolean isPaceEstablished(IPinInfo var1, CertificateHolderAuthorizationTemplate var2) throws CardApplicationException;

    public boolean supportsDestroy() throws CardApplicationException;

    public boolean supportsEid() throws CardApplicationException;

    public boolean supportsESign() throws CardApplicationException;

    public boolean supportsPace() throws CardApplicationException;

    public static class PaceChannelAttributes {
        private final int pinId;
        private final byte[] chat;

        public PaceChannelAttributes(int pinId, byte[] chat) {
            this.pinId = pinId;
            this.chat = chat;
        }

        public PaceChannelAttributes(int pinId, CertificateHolderAuthorizationTemplate chat) throws CardApplicationException {
            this.pinId = pinId;
            try {
                this.chat = chat == null ? null : chat.getDEREncoded();
            }
            catch (IOException e) {
                throw CardApplicationException.create(e);
            }
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PaceChannelAttributes other = (PaceChannelAttributes)obj;
            if (!Arrays.equals(this.chat, other.chat)) {
                return false;
            }
            return this.pinId == other.pinId;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = this.chat == null ? 31 * result + 22 : 31 * result + Arrays.hashCode(this.chat);
            result = 31 * result + this.pinId;
            return result;
        }
    }
}

