/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.algorithm.ec.EcTools;
import de.intarsys.security.algorithm.ec.EcdhTools;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tr3110.asn1.PublicKey;
import de.intarsys.tr3110.asn1.PublicKeyECDH;
import de.intarsys.tr3110.pace.KeyAgreementFunction;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyAgreementWithECDH
extends KeyAgreementFunction {
    private static final Logger Log = LoggerFactory.getLogger(KeyAgreementWithECDH.class);
    private final ECParameterSpec ecParameters;
    private KeyPair ifdMappingKeyPair;
    private ECPoint iccMappingPublicKey;
    private ECPoint iccEphemeralPublicKey;
    private KeyPair ifdEphemeralKeyPair;

    public KeyAgreementWithECDH(ECParameterSpec params) {
        this.ecParameters = params;
    }

    public ECParameterSpec getEcParameters() {
        return this.ecParameters;
    }

    @Override
    public PublicKey getIccEphemeralPublicKeyASN1() {
        PublicKeyECDH result = (PublicKeyECDH)PublicKeyECDH.FACTORY.createNew();
        result.setPublic(this.getEcParameters().getCurve(), this.getIccEphemeralPublicKeyPoint());
        return result;
    }

    @Override
    public byte[] getIccEphemeralPublicKeyCompressed() {
        ECPoint point = this.iccEphemeralPublicKey;
        ECParameterSpec parameters = this.getEcParameters();
        return EcTools.getCompressedPoint((EllipticCurve)parameters.getCurve(), (ECPoint)point);
    }

    public ECPoint getIccEphemeralPublicKeyPoint() {
        return this.iccEphemeralPublicKey;
    }

    protected KeyPair getIfdEphemeralKeyPair() {
        return this.ifdEphemeralKeyPair;
    }

    protected ECPrivateKey getIfdEphemeralPrivateKey() {
        return (ECPrivateKey)this.ifdEphemeralKeyPair.getPrivate();
    }

    protected ECPublicKey getIfdEphemeralPublicKey() {
        return (ECPublicKey)this.ifdEphemeralKeyPair.getPublic();
    }

    @Override
    public PublicKey getIfdEphemeralPublicKeyASN1() {
        PublicKeyECDH result = (PublicKeyECDH)PublicKeyECDH.FACTORY.createNew();
        result.setPublic(this.getEcParameters().getCurve(), this.getIfdEphemeralPublicKeyPoint());
        return result;
    }

    @Override
    public byte[] getIfdEphemeralPublicKeyData() throws GeneralSecurityException {
        ECPoint sharedSecret = EcTools.opMultiply((EllipticCurve)this.getEcParameters().getCurve(), (ECPoint)this.iccMappingPublicKey, (BigInteger)this.getIfdMappingPrivateKey().getS());
        ECPoint g = this.getEcParameters().getGenerator();
        ECPoint gDerived = EcTools.opAdd((EllipticCurve)this.getEcParameters().getCurve(), (ECPoint)EcTools.opMultiply((EllipticCurve)this.getEcParameters().getCurve(), (ECPoint)g, (BigInteger)this.getNonceInteger()), (ECPoint)sharedSecret);
        ECParameterSpec ecParametersDerived = new ECParameterSpec(this.getEcParameters().getCurve(), gDerived, this.getEcParameters().getOrder(), this.getEcParameters().getCofactor());
        if (this.ifdEphemeralKeyPair == null) {
            this.ifdEphemeralKeyPair = EcdhTools.generateKeyPair((ECParameterSpec)ecParametersDerived);
            Log.trace("ephemeral key pair created, PK {}", (Object)this.ifdEphemeralKeyPair.getPublic());
        }
        ECPublicKey publicKey = (ECPublicKey)this.ifdEphemeralKeyPair.getPublic();
        return EcTools.encodeECPointX9Uncompressed((EllipticCurve)this.getEcParameters().getCurve(), (ECPoint)publicKey.getW());
    }

    public ECPoint getIfdEphemeralPublicKeyPoint() {
        return this.getIfdEphemeralPublicKey().getW();
    }

    protected KeyPair getIfdMappingKeyPair() {
        return this.ifdMappingKeyPair;
    }

    protected ECPrivateKey getIfdMappingPrivateKey() {
        return (ECPrivateKey)this.ifdMappingKeyPair.getPrivate();
    }

    protected ECPublicKey getIfdMappingPublicKey() {
        return (ECPublicKey)this.ifdMappingKeyPair.getPublic();
    }

    @Override
    public byte[] getIfdMappingPublicKeyData() throws GeneralSecurityException {
        if (this.ifdMappingKeyPair == null) {
            this.ifdMappingKeyPair = EcdhTools.generateKeyPair((ECParameterSpec)this.getEcParameters());
        }
        ECPublicKey publicKey = this.getIfdMappingPublicKey();
        return EcTools.encodeECPointX9Uncompressed((EllipticCurve)this.getEcParameters().getCurve(), (ECPoint)publicKey.getW());
    }

    @Override
    public byte[] getSharedSecret() {
        ECPoint sharedSecret = EcTools.opMultiply((EllipticCurve)this.getEcParameters().getCurve(), (ECPoint)this.iccEphemeralPublicKey, (BigInteger)this.getIfdEphemeralPrivateKey().getS());
        return ByteArrayTools.toBytes((BigInteger)sharedSecret.getAffineX());
    }

    @Override
    public void setIccEphemeralPublicKey(byte[] data) {
        this.iccEphemeralPublicKey = EcTools.decodeECPointX9Uncompressed((byte[])data);
    }

    @Override
    public void setIccMappingPublicKey(byte[] data) {
        this.iccMappingPublicKey = EcTools.decodeECPointX9Uncompressed((byte[])data);
    }

    protected void setIfdEphemeralKeyPair(KeyPair ifdEphemeralKeyPair) {
        this.ifdEphemeralKeyPair = ifdEphemeralKeyPair;
    }

    protected void setIfdMappingKeyPair(KeyPair ifdMappingKeyPair) {
        this.ifdMappingKeyPair = ifdMappingKeyPair;
    }
}

