/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tr3110.pace.KeyDerivationFunction;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;

public class KeyDerivationFunction3DES112
extends KeyDerivationFunction {
    protected static final String CIPHER_3DES_CBC_NO_PADDING = "3DES/CBC/NoPadding";

    protected void adjustParity(byte[] data) {
        for (int i = 0; i < data.length; ++i) {
            int count = Integer.bitCount(data[i]);
            if ((count & 1) != 0) continue;
            int n = i;
            data[n] = (byte)(data[n] ^ 1);
        }
    }

    @Override
    public Cipher createCipher(int mode, byte[] ssc, byte[] key) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException();
    }

    @Override
    public Mac createMac(byte[] ssc, byte[] key) throws GeneralSecurityException {
        throw new NoSuchAlgorithmException();
    }

    @Override
    public byte[] deriveKey(byte[] secret, byte[] nonce, int counter) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        md.update(secret);
        if (nonce != null) {
            md.update(nonce);
        }
        md.update(ByteArrayTools.toBytesBigEndian((int)counter, (int)4));
        byte[] digest = md.digest();
        byte[] key = new byte[16];
        System.arraycopy(digest, 0, key, 0, 16);
        this.adjustParity(key);
        return key;
    }

    @Override
    public int getCipherBlockLength() {
        return 8;
    }

    @Override
    public int getMacBlockLength() {
        return 0;
    }
}

