/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.tr3110.pace.KeyDerivationFunction;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public abstract class KeyDerivationFunctionAES
extends KeyDerivationFunction {
    protected static final String PROVIDER_BC = "BC";
    protected static final String MAC_AESCMAC = "aescmac";
    protected static final String CIPHER_AES_CBC_NO_PADDING = "AES/CBC/NoPadding";
    protected static final String CIPHER_AES_ECB_NO_PADDING = "AES/ECB/NoPadding";
    protected static final String KEY_AES = "AES";
    private final Cipher cipherIV = Cipher.getInstance("AES/ECB/NoPadding");
    private final Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
    private final Mac mac = Mac.getInstance("aescmac", "BC");

    protected KeyDerivationFunctionAES() throws GeneralSecurityException {
    }

    @Override
    public Cipher createCipher(int mode, byte[] ssc, byte[] keyBytes) throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(keyBytes, KEY_AES);
        this.cipherIV.init(1, key);
        byte[] iv = this.cipherIV.doFinal(ssc);
        IvParameterSpec ips = new IvParameterSpec(iv);
        this.cipher.init(mode, (Key)key, ips);
        return this.cipher;
    }

    @Override
    public Mac createMac(byte[] ssc, byte[] keyBytes) throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(keyBytes, KEY_AES);
        this.mac.init(key);
        this.mac.update(ssc);
        return this.mac;
    }

    @Override
    public int getCipherBlockLength() {
        return 16;
    }

    @Override
    public int getMacBlockLength() {
        return 16;
    }
}

