/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.asn1.model.ASN1Based;
import de.intarsys.asn1.model.ASN1BasedTools;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.smartcard.card.ICardTransmitter;
import de.intarsys.security.smartcard.card.RequestAPDU;
import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.iso.sm.SecureMessaging;
import de.intarsys.security.smartcard.iso.sm.SecureMessagingSender;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.cmd.ICmdGeneralAuthenticate;
import de.intarsys.security.smartcard.model.cmd.ICmdManageSecurityEnvironment;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tools.crypto.CryptoTools;
import de.intarsys.tools.crypto.Secret;
import de.intarsys.tools.message.IMessage;
import de.intarsys.tools.message.IMessageBundle;
import de.intarsys.tools.message.LiteralMessage;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.asn1.CryptographicMechanismReference;
import de.intarsys.tr3110.asn1.DynamicAuthenticationData;
import de.intarsys.tr3110.asn1.PACEInfo;
import de.intarsys.tr3110.asn1.PrivateKeyReference;
import de.intarsys.tr3110.asn1.PublicKey;
import de.intarsys.tr3110.asn1.PublicKeyReference;
import de.intarsys.tr3110.asn1.SecurityInfos;
import de.intarsys.tr3110.common.CommonTools;
import de.intarsys.tr3110.pace.DomainParameters;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.KeyAgreementFunction;
import de.intarsys.tr3110.pace.KeyDerivationFunction;
import de.intarsys.tr3110.pace.KeyDerivationFunction3DES112;
import de.intarsys.tr3110.pace.KeyDerivationFunctionAES128;
import de.intarsys.tr3110.pace.KeyDerivationFunctionAES192;
import de.intarsys.tr3110.pace.KeyDerivationFunctionAES256;
import de.intarsys.tr3110.pace.PACKAGE;
import de.intarsys.tr3110.pace.PaceInputEstablishChannel;
import de.intarsys.tr3110.pace.PaceOutputEstablishChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NativePaceApplication
extends CardApplicationAdapter
implements IPaceApplication {
    private static final Logger Log = LoggerFactory.getLogger(NativePaceApplication.class);
    protected static final int DO_NONCE = 0;
    protected static final int DO_MAPPED_ICC = 2;
    protected static final int DO_MAPPED_IFD = 1;
    protected static final int DO_CAR_PREV = 8;
    protected static final int DO_CAR_CUR = 7;
    protected static final int DO_TOKEN_ICC = 6;
    protected static final int DO_TOKEN_IFD = 5;
    protected static final int DO_ID_ICC = 4;
    protected static final int DO_PK_IFD = 3;
    protected static final String MAC_AESCMAC = "aescmac";
    protected static final String PROVIDER_BC = "BC";
    protected static final String DIGEST_SHA_1 = "SHA-1";
    protected static final String ENCODING_ISO8859_1 = "ISO8859-1";
    protected static final String KEY_AES = "AES";
    protected static final String CIPHER_AES_CBC_NO_PADDING = "AES/CBC/NoPadding";
    protected static final String PROTOCOL_SUFFIX_4 = ".4";
    protected static final String PROTOCOL_SUFFIX_3 = ".3";
    protected static final String PROTOCOL_SUFFIX_2 = ".2";
    protected static final String PROTOCOL_SUFFIX_1 = ".1";
    private static final IMessageBundle Msg = PACKAGE.Messages;
    protected static final int P1_PACE = 193;
    private IPinInfo pinInfo;
    private String protocol;
    private int version;
    private Integer parameterId;
    private DomainParameters domainParameters;
    private KeyDerivationFunction keyDerivationFunction;
    private KeyAgreementFunction keyAgreementFunction;
    private byte[] keyBytesEnc;
    private byte[] keyBytesMac;
    private byte[] tokenIcc;
    private byte[] carCur;
    private byte[] carPrev;
    private CertificateHolderAuthorizationTemplate chat;
    private byte[] certificateDescription;
    private int statusMseSetAT = 0;
    private int resultCode = 0;
    private final SecureMessaging.IAlgorithmFactory algorithmFactory = new SecureMessaging.IAlgorithmFactory(){

        @Override
        public Cipher createCipher(int mode, byte[] ssc) throws GeneralSecurityException {
            return NativePaceApplication.this.getKeyDerivationFunction().createCipher(mode, ssc, NativePaceApplication.this.getKeyBytesEnc());
        }

        @Override
        public Mac createMac(byte[] ssc) throws GeneralSecurityException {
            return NativePaceApplication.this.getKeyDerivationFunction().createMac(ssc, NativePaceApplication.this.getKeyBytesMac());
        }

        @Override
        public int getCipherBlockLength() {
            return NativePaceApplication.this.getKeyDerivationFunction().getCipherBlockLength();
        }

        @Override
        public int getMacBlockLength() {
            return NativePaceApplication.this.getKeyDerivationFunction().getMacBlockLength();
        }
    };

    protected void cachePinBytes() throws CardApplicationException {
        Secret tempPin = this.getAuthenticationPin();
        if (!CryptoTools.isEmpty((Secret)tempPin)) {
            String tempPinId = "pace-" + this.getPinInfo().getId();
            this.getCard().setAttribute((Object)tempPinId, (Object)tempPin);
        }
    }

    protected ResponseAPDU cmdGeneralAuthenticate(byte[] data, boolean chained) throws CardApplicationException {
        ICmdGeneralAuthenticate cmd = this.getCommand(ICmdGeneralAuthenticate.class);
        RequestAPDU req = cmd.create(data);
        req.setChainedRequest(chained);
        return this.sendRequest(cmd, req);
    }

    protected ResponseAPDU cmdMseSetAT(byte[] data) throws CardApplicationException {
        ICmdManageSecurityEnvironment mse = this.getCommand(ICmdManageSecurityEnvironment.class);
        RequestAPDU req = mse.createRaw(193, 164, data);
        ResponseAPDU res = this.transmit(req);
        this.setStatusMseSetAT(res.getSw());
        if (res.getSw1() != 99 && res.getSw() != 36864) {
            this.getCardProduct().checkResponse(req, res);
        }
        return res;
    }

    protected CryptographicMechanismReference createCryptographicMechanismReference() {
        CryptographicMechanismReference asnCRM = (CryptographicMechanismReference)CryptographicMechanismReference.FACTORY.createNew();
        asnCRM.setProtocol(this.getProtocol());
        return asnCRM;
    }

    protected KeyDerivationFunction createKeyDerivationFunction() throws CardApplicationException {
        try {
            if (this.getProtocol().endsWith(PROTOCOL_SUFFIX_1)) {
                Log.debug("Native PACE create KeyDerivationFunction3DES112");
                return new KeyDerivationFunction3DES112();
            }
            if (this.getProtocol().endsWith(PROTOCOL_SUFFIX_2)) {
                Log.debug("Native PACE create KeyDerivationFunctionAES128");
                return new KeyDerivationFunctionAES128();
            }
            if (this.getProtocol().endsWith(PROTOCOL_SUFFIX_3)) {
                Log.debug("Native PACE create KeyDerivationFunctionAES192");
                return new KeyDerivationFunctionAES192();
            }
            if (this.getProtocol().endsWith(PROTOCOL_SUFFIX_4)) {
                Log.debug("Native PACE create KeyDerivationFunctionAES256");
                return new KeyDerivationFunctionAES256();
            }
        }
        catch (GeneralSecurityException e) {
            throw CardApplicationException.create("PACE key derivation for " + this.getProtocol() + " failed", e);
        }
        throw new CardApplicationException("PACE key derivation for " + this.getProtocol() + " not supported");
    }

    protected byte[] createKeyEncryption(byte[] secret) throws GeneralSecurityException {
        return this.getKeyDerivationFunction().deriveKey(secret, null, 1);
    }

    protected byte[] createKeyMac(byte[] secret) throws GeneralSecurityException {
        return this.getKeyDerivationFunction().deriveKey(secret, null, 2);
    }

    protected PrivateKeyReference createPrivateKeyReferences() {
        PrivateKeyReference asnPrkr = (PrivateKeyReference)PrivateKeyReference.FACTORY.createNew();
        asnPrkr.setReference(this.getParameterId());
        return asnPrkr;
    }

    protected PublicKeyReference createPublicKeyReference() {
        PublicKeyReference asnPkr = (PublicKeyReference)PublicKeyReference.FACTORY.createNew();
        asnPkr.setReference(this.getPinInfo().getReference());
        return asnPkr;
    }

    protected byte[] decryptNonce(byte[] nonceZ) throws GeneralSecurityException, CardApplicationException {
        byte[] keyBytes = this.getKeyDerivationFunction().deriveKey(this.getPinBytes(), null, 3);
        Cipher cipher = Cipher.getInstance(CIPHER_AES_CBC_NO_PADDING);
        SecretKeySpec key = new SecretKeySpec(keyBytes, KEY_AES);
        IvParameterSpec ips = new IvParameterSpec(new byte[keyBytes.length], 0, this.getKeyDerivationFunction().getCipherBlockLength());
        cipher.init(2, (Key)key, ips);
        return cipher.doFinal(nonceZ);
    }

    @Override
    public void destroyPaceChannel() throws CardApplicationException {
        ICardTransmitter transmitter = this.getCardTransmitter();
        if (transmitter instanceof SecureMessagingSender) {
            SecureMessagingSender smTransmitter = (SecureMessagingSender)transmitter;
            this.setCardTransmitter(smTransmitter.getCardTransmitter());
        }
    }

    @Override
    public PaceOutputEstablishChannel establishPaceChannel(PaceInputEstablishChannel input) throws CardApplicationException {
        this.setPinInfo(input.getPinInfo());
        this.setChat(input.getChat());
        if (input.getPin() != null && input.getPin().length > 0) {
            this.setAuthenticationPin(Secret.hide((byte[])input.getPin()));
        }
        this.setCertificateDescription(input.getCertificateDescription());
        this.perform();
        try {
            ByteArrayOutputStream osOutData = new ByteArrayOutputStream();
            this.writeOutData(osOutData);
            ByteArrayOutputStream osOutBuffer = new ByteArrayOutputStream();
            ByteArrayTools.writeLittleEndian((OutputStream)osOutBuffer, (int)this.getResultCode(), (int)4);
            ByteArrayTools.writeLittleEndian((OutputStream)osOutBuffer, (int)osOutData.size(), (int)2);
            osOutBuffer.write(osOutData.toByteArray());
            PaceOutputEstablishChannel result = new PaceOutputEstablishChannel(osOutBuffer.toByteArray());
            return result;
        }
        catch (IOException e) {
            throw CardApplicationException.create(e);
        }
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return this.getPinInfo();
    }

    protected byte[] getCarCur() {
        return this.carCur;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IPaceApplication.class;
    }

    protected byte[] getCarPrev() {
        return this.carPrev;
    }

    protected byte[] getCertificateDescription() {
        return this.certificateDescription;
    }

    public CertificateHolderAuthorizationTemplate getChat() {
        return this.chat;
    }

    protected DomainParameters getDomainParameters() {
        return this.domainParameters;
    }

    protected KeyAgreementFunction getKeyAgreementFunction() {
        return this.keyAgreementFunction;
    }

    protected byte[] getKeyBytesEnc() {
        return this.keyBytesEnc;
    }

    protected byte[] getKeyBytesMac() {
        return this.keyBytesMac;
    }

    protected KeyDerivationFunction getKeyDerivationFunction() {
        return this.keyDerivationFunction;
    }

    @Override
    protected IMessageBundle getMessageBundle() {
        return Msg;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "PaceApp";
    }

    protected Integer getParameterId() {
        return this.parameterId;
    }

    protected byte[] getPinBytes() throws CardApplicationException {
        String tempPinId = "pace-" + this.getPinInfo().getId();
        Secret tempPin = this.getAuthenticationPin();
        if (CryptoTools.isEmpty((Secret)tempPin)) {
            tempPin = (Secret)this.getCard().getAttribute((Object)tempPinId);
        }
        if (CryptoTools.isEmpty((Secret)tempPin)) {
            IMessage title = LiteralMessage.create((String)"PACE authentication");
            IMessage prompt = this.getAuthenticationPromptExpanded(false);
            tempPin = this.queryPin(tempPinId, title, prompt);
        }
        if (CryptoTools.isEmpty((Secret)tempPin)) {
            throw new CardAuthenticationCanceledException();
        }
        this.setAuthenticationPin(tempPin);
        try {
            byte[] bytes = tempPin.getString().getBytes(ENCODING_ISO8859_1);
            if (this.getPinInfo().getReference() == 1) {
                MessageDigest digest = MessageDigest.getInstance(DIGEST_SHA_1);
                return digest.digest(bytes);
            }
            return bytes;
        }
        catch (Exception e) {
            throw CardApplicationException.create(e);
        }
    }

    public IPinInfo getPinInfo() {
        return this.pinInfo;
    }

    protected String getProtocol() {
        return this.protocol;
    }

    protected int getResultCode() {
        return this.resultCode;
    }

    protected int getStatusMseSetAT() {
        return this.statusMseSetAT;
    }

    protected byte[] getToken(byte[] keyBytes, PublicKey asnPublicKey) throws GeneralSecurityException, IOException {
        return this.macData(keyBytes, asnPublicKey.getDEREncoded());
    }

    public int getVersion() {
        return this.version;
    }

    @Override
    public boolean isNative() {
        return true;
    }

    @Override
    public boolean isPaceEstablished(IPinInfo pacePinInfo, CertificateHolderAuthorizationTemplate chat) throws CardApplicationException {
        ICardTransmitter transmitter = this.getConnectionState().getCardTransmitter();
        if (transmitter instanceof PaceChannelSender) {
            IPaceApplication.PaceChannelAttributes currentAttributes = ((PaceChannelSender)transmitter).getAttributes();
            IPaceApplication.PaceChannelAttributes newAttributes = new IPaceApplication.PaceChannelAttributes(pacePinInfo.getReference(), chat);
            return newAttributes.equals(currentAttributes);
        }
        return false;
    }

    protected boolean isTerminalAuthentication() {
        return this.getChat() != null;
    }

    protected byte[] macData(byte[] keyBytes, byte[] data) throws GeneralSecurityException {
        SecretKeySpec key = new SecretKeySpec(keyBytes, KEY_AES);
        Mac mac = Mac.getInstance(MAC_AESCMAC, PROVIDER_BC);
        mac.init(key);
        byte[] temp = mac.doFinal(data);
        return Arrays.copyOf((byte[])temp, (int)8);
    }

    public void perform() throws CardApplicationException {
        try {
            this.performSetUp();
            this.performSetSecurityEnvironment();
            this.performRequestNonce();
            this.performMapNonce();
            this.performExchangeEphemeralKeys();
            this.performCreateSessionKeys();
            this.performExchangeTokens();
            this.performCheckToken();
            IPaceApplication.PaceChannelAttributes attributes = new IPaceApplication.PaceChannelAttributes(this.getPinInfo().getReference(), this.getChat());
            PaceChannelSender transmitter = new PaceChannelSender(this.getCardTransmitter(), attributes);
            transmitter.setAlgorithmFactory(this.algorithmFactory);
            transmitter.setChecksumLength(8);
            this.setCardTransmitter((ICardTransmitter)transmitter);
            this.cachePinBytes();
        }
        catch (Exception e) {
            throw CardApplicationException.create(e);
        }
    }

    protected void performCheckToken() throws GeneralSecurityException, IOException, CardApplicationException {
        PublicKey ifdPublicKey = this.getKeyAgreementFunction().getIfdEphemeralPublicKeyASN1();
        ifdPublicKey.setIdentifier(this.getProtocol());
        byte[] tokenIccReference = this.getToken(this.getKeyBytesMac(), ifdPublicKey);
        if (!Arrays.areEqual((byte[])this.tokenIcc, (byte[])tokenIccReference)) {
            throw new CardApplicationException("authentication failed");
        }
    }

    protected void performCreateSessionKeys() throws GeneralSecurityException {
        byte[] sharedSecret = this.getKeyAgreementFunction().getSharedSecret();
        this.setKeyBytesEnc(this.createKeyEncryption(sharedSecret));
        this.setKeyBytesMac(this.createKeyMac(sharedSecret));
    }

    protected void performExchangeEphemeralKeys() throws GeneralSecurityException, CardApplicationException, IOException {
        byte[] publicKeyIfd = this.getKeyAgreementFunction().getIfdEphemeralPublicKeyData();
        DynamicAuthenticationData ansDAD3Request = (DynamicAuthenticationData)DynamicAuthenticationData.FACTORY.createNew();
        ansDAD3Request.addDataObject(3, publicKeyIfd);
        Log.debug("NativePace authenticate key agreement (general authenticate)");
        ResponseAPDU response = this.cmdGeneralAuthenticate(ansDAD3Request.getDEREncoded(), true);
        DynamicAuthenticationData ansDAD3Response = (DynamicAuthenticationData)ASN1BasedTools.create((ASN1Based.Factory)DynamicAuthenticationData.FACTORY, (byte[])response.getData());
        byte[] pkIcc = ansDAD3Response.getDataObject(4);
        this.getKeyAgreementFunction().setIccEphemeralPublicKey(pkIcc);
    }

    protected void performExchangeTokens() throws GeneralSecurityException, IOException, CardApplicationException {
        PublicKey iccPublicKey = this.getKeyAgreementFunction().getIccEphemeralPublicKeyASN1();
        iccPublicKey.setIdentifier(this.getProtocol());
        byte[] tokenIfd = this.getToken(this.getKeyBytesMac(), iccPublicKey);
        DynamicAuthenticationData ansDAD4Request = (DynamicAuthenticationData)DynamicAuthenticationData.FACTORY.createNew();
        ansDAD4Request.addDataObject(5, tokenIfd);
        Log.debug("NativePace exchange tokens (general authenticate)");
        ResponseAPDU response = this.cmdGeneralAuthenticate(ansDAD4Request.getDEREncoded(), false);
        DynamicAuthenticationData ansDAD4Response = (DynamicAuthenticationData)ASN1BasedTools.create((ASN1Based.Factory)DynamicAuthenticationData.FACTORY, (byte[])response.getData());
        this.tokenIcc = ansDAD4Response.getDataObject(6);
        this.carCur = ansDAD4Response.getDataObject(7);
        if (this.carCur == null) {
            this.carCur = new byte[0];
        }
        this.carPrev = ansDAD4Response.getDataObject(8);
        if (this.carPrev == null) {
            this.carPrev = new byte[0];
        }
    }

    protected void performMapNonce() throws GeneralSecurityException, CardApplicationException, IOException {
        byte[] mappedIfd = this.getKeyAgreementFunction().getIfdMappingPublicKeyData();
        DynamicAuthenticationData ansDAD2Request = (DynamicAuthenticationData)DynamicAuthenticationData.FACTORY.createNew();
        ansDAD2Request.addDataObject(1, mappedIfd);
        Log.debug("NativePace map nonce (general authenticate)");
        ResponseAPDU response = this.cmdGeneralAuthenticate(ansDAD2Request.getDEREncoded(), true);
        DynamicAuthenticationData ansDAD2Response = (DynamicAuthenticationData)ASN1BasedTools.create((ASN1Based.Factory)DynamicAuthenticationData.FACTORY, (byte[])response.getData());
        byte[] mappedIcc = ansDAD2Response.getDataObject(2);
        this.getKeyAgreementFunction().setIccMappingPublicKey(mappedIcc);
    }

    protected void performRequestNonce() throws CardApplicationException, IOException, GeneralSecurityException {
        DynamicAuthenticationData ansDAD1Request = (DynamicAuthenticationData)DynamicAuthenticationData.FACTORY.createNew();
        Log.debug("NativePace request nonce");
        ResponseAPDU response = this.cmdGeneralAuthenticate(ansDAD1Request.getDEREncoded(), true);
        DynamicAuthenticationData ansDAD1Response = (DynamicAuthenticationData)ASN1BasedTools.create((ASN1Based.Factory)DynamicAuthenticationData.FACTORY, (byte[])response.getData());
        byte[] nonceZ = ansDAD1Response.getDataObject(0);
        byte[] nonceS = this.decryptNonce(nonceZ);
        this.getKeyAgreementFunction().setNonce(nonceS);
    }

    protected void performSetSecurityEnvironment() throws IOException, CardApplicationException {
        CryptographicMechanismReference asnCRM = this.createCryptographicMechanismReference();
        PublicKeyReference asnPkr = this.createPublicKeyReference();
        PrivateKeyReference asnPrkr = this.createPrivateKeyReferences();
        byte[] bytes = ASN1Tools.toByteArray((ASN1Encodable[])new ASN1Encodable[]{asnPkr, asnCRM, asnPrkr, this.getChat()});
        Log.debug("NativePace mse set AT");
        this.cmdMseSetAT(bytes);
    }

    protected void performSetUp() throws CardApplicationException, IOException {
        SecurityInfos securityInfos = CommonTools.getSecurityInfos(this.getCardProduct(), this.getCardConnection());
        for (PACEInfo paceInfo : securityInfos.getPACEInfos()) {
            this.setProtocol(paceInfo.getProtocol());
            this.setVersion(paceInfo.getVersion());
            this.setParameterId(paceInfo.getParameterId());
        }
        if (this.getParameterId() == null) {
            throw new CardApplicationException("PACE with explicit domain parameters not supported");
        }
        this.domainParameters = DomainParameters.create(this.getParameterId());
        this.setKeyAgreementFunction(this.getDomainParameters().createKeyAgreementFunction());
        this.setKeyDerivationFunction(this.createKeyDerivationFunction());
    }

    public void setCertificateDescription(byte[] certificateDescription) {
        this.certificateDescription = certificateDescription;
    }

    public void setChat(CertificateHolderAuthorizationTemplate chat) {
        this.chat = chat;
    }

    protected void setDomainParameters(DomainParameters domainParameters) {
        this.domainParameters = domainParameters;
    }

    protected void setKeyAgreementFunction(KeyAgreementFunction keyAgreementFunction) {
        this.keyAgreementFunction = keyAgreementFunction;
    }

    protected void setKeyBytesEnc(byte[] keyBytesEnc) {
        this.keyBytesEnc = keyBytesEnc;
    }

    protected void setKeyBytesMac(byte[] keyBytesMac) {
        this.keyBytesMac = keyBytesMac;
    }

    protected void setKeyDerivationFunction(KeyDerivationFunction keyDerivationFunction) {
        this.keyDerivationFunction = keyDerivationFunction;
    }

    protected void setParameterId(Integer parameterId) {
        Log.debug("NativePace parameterId:" + parameterId);
        this.parameterId = parameterId;
    }

    public void setPinInfo(IPinInfo pinInfo) {
        this.pinInfo = pinInfo;
    }

    protected void setProtocol(String protocolOid) {
        Log.debug("NativePace protocol:" + protocolOid);
        this.protocol = protocolOid;
    }

    protected void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    protected void setStatusMseSetAT(int statusMseSetAT) {
        this.statusMseSetAT = statusMseSetAT;
    }

    protected void setVersion(int version) throws CardApplicationException {
        if (version != 2) {
            throw new CardApplicationException("PACE version " + version + " not supported");
        }
        Log.debug("NativePace version:" + version);
        this.version = version;
    }

    @Override
    public boolean supportsDestroy() throws CardApplicationException {
        return true;
    }

    @Override
    public boolean supportsEid() throws CardApplicationException {
        return true;
    }

    @Override
    public boolean supportsESign() throws CardApplicationException {
        return true;
    }

    @Override
    public boolean supportsPace() throws CardApplicationException {
        return true;
    }

    protected void writeOutData(ByteArrayOutputStream os) throws IOException, CardApplicationException {
        ByteArrayTools.writeLittleEndian((OutputStream)os, (int)this.getStatusMseSetAT(), (int)2);
        byte[] efCardAcess = CommonTools.getEFCardAccess(this.getCardProduct(), this.getCardConnection());
        ByteArrayTools.writeLittleEndian((OutputStream)os, (int)efCardAcess.length, (int)2);
        os.write(efCardAcess);
        if (this.isTerminalAuthentication()) {
            ByteArrayTools.writeLittleEndian((OutputStream)os, (int)this.getCarCur().length, (int)1);
            os.write(this.getCarCur());
            ByteArrayTools.writeLittleEndian((OutputStream)os, (int)this.getCarPrev().length, (int)1);
            os.write(this.getCarPrev());
            byte[] idIcc = this.getKeyAgreementFunction().getIccEphemeralPublicKeyCompressed();
            ByteArrayTools.writeLittleEndian((OutputStream)os, (int)idIcc.length, (int)2);
            os.write(idIcc);
        }
    }

    public static class PaceChannelSender
    extends SecureMessagingSender {
        private final IPaceApplication.PaceChannelAttributes attributes;

        public PaceChannelSender(ICardTransmitter transmitter, IPaceApplication.PaceChannelAttributes attributes) {
            super(transmitter);
            this.attributes = attributes;
        }

        public IPaceApplication.PaceChannelAttributes getAttributes() {
            return this.attributes;
        }
    }
}

