/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.smartcard.cardterminal.CardTerminalTools;
import de.intarsys.security.smartcard.cardterminal.ICardTerminalProduct;
import de.intarsys.security.smartcard.model.ICardApplication;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationAdapter;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.NativePaceApplication;
import de.intarsys.tr3110.pace.PaceInputEstablishChannel;
import de.intarsys.tr3110.pace.PaceOutputEstablishChannel;
import jakarta.annotation.PostConstruct;

public class PaceApplication
extends CardApplicationAdapter
implements IPaceApplication {
    private IPaceApplication realApplication;

    protected IPaceApplication createRealApp() throws CardApplicationException {
        IPaceApplication app = null;
        if (!this.isDisableSPE()) {
            ICardTerminalProduct product = CardTerminalTools.getCardTerminalProduct(this.getCardConnection());
            try {
                app = product.createCardApplication(this.getCardConnection(), IPaceApplication.class);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (app == null || !app.supportsPace()) {
            NativePaceApplication tempApp = new NativePaceApplication();
            tempApp.setCardProduct(this.getCardProduct());
            tempApp.setCardConnection(this.getCardConnection());
            tempApp.initialize();
            app = tempApp;
        }
        return app;
    }

    @Override
    public void destroyPaceChannel() throws CardApplicationException {
        this.realApplication.destroyPaceChannel();
    }

    @Override
    public PaceOutputEstablishChannel establishPaceChannel(PaceInputEstablishChannel input) throws CardApplicationException {
        return this.realApplication.establishPaceChannel(input);
    }

    @Override
    public IPinInfo getAuthenticationPinInfo() {
        return null;
    }

    @Override
    protected Class<? extends ICardApplication> getCardApplicationType() {
        return IPaceApplication.class;
    }

    @Override
    protected String getMsgPromptCodePrefix() {
        return "PaceApp";
    }

    @Override
    @PostConstruct
    public void initialize() throws CardApplicationException {
        super.initialize();
        this.realApplication = this.createRealApp();
    }

    @Override
    public boolean isNative() {
        return this.realApplication.isNative();
    }

    @Override
    public boolean isPaceEstablished(IPinInfo pacePinInfo, CertificateHolderAuthorizationTemplate chat) throws CardApplicationException {
        return this.realApplication.isPaceEstablished(pacePinInfo, chat);
    }

    @Override
    public boolean supportsDestroy() throws CardApplicationException {
        return this.realApplication.supportsDestroy();
    }

    @Override
    public boolean supportsEid() throws CardApplicationException {
        return this.realApplication.supportsEid();
    }

    @Override
    public boolean supportsESign() throws CardApplicationException {
        return this.realApplication.supportsESign();
    }

    @Override
    public boolean supportsPace() throws CardApplicationException {
        return this.realApplication.supportsPace();
    }
}

