/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.smartcard.card.ResponseAPDU;
import de.intarsys.security.smartcard.model.IResponseValidator;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationCanceledException;
import de.intarsys.security.smartcard.model.app.CardAuthenticationTimeout;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tr3110.pace.PaceInputDataException;
import de.intarsys.tr3110.pace.PaceProtocolException;

public class PaceOutput {
    protected final byte[] buffer;

    public static void checkReturnValue(PaceOutput returnValue, IResponseValidator validator) throws CardApplicationException {
        int code = returnValue.getReturnCode();
        int errorCode = code & 0xFFFF;
        int sw1 = errorCode >>> 8;
        int sw2 = errorCode & 0xFF;
        int errorType = code >>> 16;
        if (errorType != 0) {
            if ((errorType & 0xFF00) == 53248) {
                throw new PaceInputDataException(code);
            }
            if ((errorType & 0xFF00) == 57344) {
                if (sw2 == 7) {
                    throw new PaceProtocolException("PACE Authentisierungsfehler (" + Integer.toHexString(code) + ")");
                }
                throw new PaceProtocolException("PACE protocol error, 0x" + Integer.toHexString(code));
            }
            if (code == -267386879) {
                throw new PaceProtocolException("PACE Kommunikationsabbruch");
            }
            if (code == -267386878) {
                throw new PaceProtocolException("PACE Karte nicht gefunden");
            }
            if (code == -266338303) {
                throw new CardAuthenticationCanceledException();
            }
            if (code == -266338302) {
                throw new CardAuthenticationTimeout();
            }
            if ((errorType & 0xFF00) == 61440) {
                if (sw1 == 105 && sw2 == 130) {
                    throw new PaceProtocolException("PACE Authentisierungsfehler (" + Integer.toHexString(code) + ")");
                }
                if (validator != null) {
                    ResponseAPDU resp = new ResponseAPDU(new byte[0], sw1, sw2);
                    validator.checkResponse(null, resp);
                }
            } else {
                if ((errorType & 0xFF00) == 63488) {
                    throw new PaceProtocolException("PACE Authentisierungsfehler (" + Integer.toHexString(code) + ")");
                }
                throw new PaceProtocolException("PACE Authentisierungsfehler (" + Integer.toHexString(code) + ")");
            }
        }
    }

    public PaceOutput(byte[] pOutBuffer) throws CardApplicationException {
        if (pOutBuffer.length < 4) {
            throw new CardApplicationException("Not a valid PACE return value");
        }
        this.buffer = pOutBuffer;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] getData() {
        int lenData = this.getDataLength();
        if (this.buffer.length >= 6 + lenData) {
            return ByteArrayTools.copy((byte[])this.buffer, (int)6, (int)lenData);
        }
        return new byte[0];
    }

    public int getDataLength() {
        if (this.buffer.length >= 6) {
            return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)4, (int)2);
        }
        return 0;
    }

    public int getReturnCode() {
        return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)0, (int)4);
    }
}

