/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.tools.collection.ByteArrayTools;
import de.intarsys.tr3110.pace.PaceOutput;

public class PaceOutputEstablishChannel
extends PaceOutput {
    public PaceOutputEstablishChannel(byte[] pOutBuffer) throws CardApplicationException {
        super(pOutBuffer);
    }

    public byte[] getCar() {
        int lenCar;
        int lenEf = this.getEfCardAccessLength();
        if (this.buffer.length >= 11 + lenEf + (lenCar = this.getCarLength())) {
            return ByteArrayTools.copy((byte[])this.buffer, (int)(11 + lenEf), (int)lenCar);
        }
        return null;
    }

    public int getCarLength() {
        int lenEF = this.getEfCardAccessLength();
        if (this.buffer.length >= 11 + lenEF) {
            return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)(10 + lenEF), (int)1);
        }
        return 0;
    }

    public byte[] getCarPrev() {
        int lenCarPrev;
        int lenCar;
        int lenEf = this.getEfCardAccessLength();
        if (this.buffer.length >= 12 + lenEf + (lenCar = this.getCarLength()) + (lenCarPrev = this.getCarPrevLength())) {
            return ByteArrayTools.copy((byte[])this.buffer, (int)(12 + lenEf + lenCar), (int)lenCarPrev);
        }
        return null;
    }

    public int getCarPrevLength() {
        int lenCar;
        int lenEF = this.getEfCardAccessLength();
        if (this.buffer.length >= 12 + lenEF + (lenCar = this.getCarLength())) {
            return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)(11 + lenEF + lenCar), (int)1);
        }
        return 0;
    }

    public byte[] getEfCardAccess() {
        int lenEf = this.getEfCardAccessLength();
        if (this.buffer.length >= 10 + lenEf) {
            return ByteArrayTools.copy((byte[])this.buffer, (int)10, (int)lenEf);
        }
        return new byte[0];
    }

    public int getEfCardAccessLength() {
        if (this.buffer.length >= 10) {
            return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)8, (int)2);
        }
        return 0;
    }

    public byte[] getIdIcc() {
        int lenIdIcc;
        int lenCarPrev;
        int lenCar;
        int lenEf = this.getEfCardAccessLength();
        if (this.buffer.length >= 14 + lenEf + (lenCar = this.getCarLength()) + (lenCarPrev = this.getCarPrevLength()) + (lenIdIcc = this.getIdIccLength())) {
            return ByteArrayTools.copy((byte[])this.buffer, (int)(14 + lenEf + lenCar + lenCarPrev), (int)lenIdIcc);
        }
        return null;
    }

    public int getIdIccLength() {
        int lenCarPrev;
        int lenCar;
        int lenEF = this.getEfCardAccessLength();
        if (this.buffer.length >= 14 + lenEF + (lenCar = this.getCarLength()) + (lenCarPrev = this.getCarPrevLength())) {
            return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)(12 + lenEF + lenCar + lenCarPrev), (int)2);
        }
        return 0;
    }

    public int getMseStatus() {
        if (this.buffer.length >= 8) {
            return ByteArrayTools.toLittleEndianIntUnsigned((byte[])this.buffer, (int)6, (int)2);
        }
        return 0;
    }
}

