/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tr3110.pace;

import de.intarsys.security.smartcard.app.filesystem.CardFileSelector;
import de.intarsys.security.smartcard.app.filesystem.IFileSystemApplication;
import de.intarsys.security.smartcard.card.ICardConnection;
import de.intarsys.security.smartcard.model.CardProductTools;
import de.intarsys.security.smartcard.model.ICardProduct;
import de.intarsys.security.smartcard.model.IPinInfo;
import de.intarsys.security.smartcard.model.app.CardApplicationCardReset;
import de.intarsys.security.smartcard.model.app.CardApplicationCardUnavailable;
import de.intarsys.security.smartcard.model.app.CardApplicationException;
import de.intarsys.security.smartcard.model.app.CardApplicationNotSupported;
import de.intarsys.tr3110.asn1.CertificateHolderAuthorizationTemplate;
import de.intarsys.tr3110.pace.IPaceApplication;
import de.intarsys.tr3110.pace.PaceInputEstablishChannel;
import de.intarsys.tr3110.pace.PaceProtocolException;

public final class PaceTools {
    public static void establishPaceChannel(ICardConnection connection, CardFileSelector targetDir, IPinInfo pacePinInfo, byte[] pacePin, String chatId, byte[] discretionaryData) throws CardApplicationException {
        IPaceApplication paceApp = PaceTools.getPaceApplication(connection);
        PaceInputEstablishChannel input = new PaceInputEstablishChannel();
        try {
            CertificateHolderAuthorizationTemplate chat = CertificateHolderAuthorizationTemplate.create(chatId, discretionaryData);
            if (paceApp.isPaceEstablished(pacePinInfo, chat) && (targetDir == null || PaceTools.getFileSystem(connection).isSelected(targetDir))) {
                return;
            }
            if (paceApp.supportsDestroy()) {
                paceApp.destroyPaceChannel();
            }
            try {
                PaceTools.getFileSystem(connection).selectRoot(false);
            }
            catch (CardApplicationException cardApplicationException) {
                // empty catch block
            }
            input.setPinInfo(pacePinInfo);
            input.setChat(chat);
            input.setPin(pacePin);
            input.setCertificateDescription(null);
            paceApp.establishPaceChannel(input);
        }
        catch (PaceProtocolException e) {
            paceApp.establishPaceChannel(input);
        }
        catch (Exception e) {
            throw CardApplicationException.create(e);
        }
    }

    protected static IFileSystemApplication getFileSystem(ICardConnection connection) throws CardApplicationException {
        ICardProduct cardProduct = CardProductTools.getCardProduct(connection);
        return cardProduct.createCardApplication(connection, IFileSystemApplication.class);
    }

    public static IPaceApplication getPaceApplication(ICardConnection connection) throws CardApplicationException {
        try {
            ICardProduct cardProduct = CardProductTools.getCardProduct(connection);
            IPaceApplication paceApp = cardProduct.createCardApplication(connection, IPaceApplication.class);
            if (paceApp == null || !paceApp.supportsPace()) {
                throw new CardApplicationNotSupported(IPaceApplication.class);
            }
            return paceApp;
        }
        catch (CardApplicationException e) {
            throw new CardApplicationNotSupported(IPaceApplication.class);
        }
    }

    public static boolean isCardSecurityReadable(ICardConnection connection) throws CardApplicationException {
        try {
            ICardProduct product = CardProductTools.getCardProduct(connection);
            IFileSystemApplication fileSystem = product.createCardApplication(connection, IFileSystemApplication.class);
            CardFileSelector selector = product.getCardInfo().lookupFileSelector("EF.CardSecurity");
            fileSystem.readBinary(selector);
            return true;
        }
        catch (CardApplicationCardReset e) {
            throw e;
        }
        catch (CardApplicationCardUnavailable e) {
            throw e;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private PaceTools() {
    }
}

