/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.http.content.HttpEntityDecoder;
import de.intarsys.tools.stream.StreamTools;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.json.JsonString;
import jakarta.json.JsonValue;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;

public class HttpEntityApplicationJsonDecoder
extends HttpEntityDecoder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object basicDecode(Header[] headers, HttpEntity entity) throws IOException {
        if (entity == null) {
            return null;
        }
        InputStream is = entity.getContent();
        try {
            JsonReader reader = Json.createReader((Reader)new InputStreamReader(is, StandardCharsets.UTF_8));
            JsonObject json = reader.readObject();
            Object object = this.unwrap((JsonValue)json);
            return object;
        }
        finally {
            StreamTools.close((Closeable)is);
        }
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    protected Object unwrap(JsonArray json) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (JsonValue value : json) {
            result.add(this.unwrap(value));
        }
        return result;
    }

    protected Object unwrap(JsonObject json) {
        HashMap result = new HashMap();
        for (Map.Entry entry : json.entrySet()) {
            result.put(entry.getKey(), this.unwrap((JsonValue)entry.getValue()));
        }
        return result;
    }

    protected Object unwrap(JsonValue json) {
        JsonValue.ValueType type = json.getValueType();
        switch (type) {
            case ARRAY: {
                return this.unwrap((JsonArray)json);
            }
            case OBJECT: {
                return this.unwrap((JsonObject)json);
            }
            case STRING: {
                return ((JsonString)json).getString();
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)json;
                if (number.isIntegral()) {
                    return ((JsonNumber)json).intValue();
                }
                return ((JsonNumber)json).doubleValue();
            }
            case FALSE: {
                return false;
            }
            case TRUE: {
                return true;
            }
            case NULL: {
                return null;
            }
        }
        return null;
    }
}

