/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.http.content;

import de.intarsys.tools.converter.ConversionException;
import de.intarsys.tools.converter.ConverterRegistry;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.http.content.HttpEntityEncoder;
import de.intarsys.tools.http.httpcomponents.ByteBody;
import de.intarsys.tools.http.httpcomponents.LocatorBody;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorTools;
import de.intarsys.tools.string.StringTools;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class HttpEntityMultipartFormDataEncoder
extends HttpEntityEncoder {
    @Override
    protected HttpEntity basicEncode(Object value) throws IOException {
        value = this.wrap(value);
        MultipartEntity entity = new MultipartEntity();
        this.createEntity(entity, null, value);
        return entity;
    }

    protected void createEntity(MultipartEntity entity, String name, Object value) throws IOException {
        if (value instanceof IArgs) {
            this.createEntityArgs(entity, name, (IArgs)value);
        } else if (value instanceof Map) {
            this.createEntityMap(entity, name, (Map)value);
        } else if (value instanceof Object[]) {
            this.createEntityArray(entity, name, (Object[])value);
        } else if (value instanceof Collection) {
            this.createEntityCollection(entity, name, (Collection)value);
        } else if (value instanceof Iterator) {
            this.createEntityIterator(entity, name, (Iterator)value);
        } else {
            entity.addPart(name, this.createEntityPrimitiveBody(entity, value));
        }
    }

    protected void createEntityArgs(MultipartEntity entity, String prefix, IArgs args) throws IOException {
        int i = 0;
        Iterator it = args.bindings();
        while (it.hasNext()) {
            IArgs.IBinding binding = (IArgs.IBinding)it.next();
            Object name = binding.getName();
            if (name == null) {
                name = "" + i;
            }
            ++i;
            Object value = binding.getValue();
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(entity, tempName, value);
        }
    }

    protected void createEntityArray(MultipartEntity entity, String prefix, Object[] array) throws IOException {
        for (int i = 0; i < array.length; ++i) {
            String name = String.valueOf(i);
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            Object value = array[i];
            this.createEntity(entity, tempName, value);
        }
    }

    protected void createEntityCollection(MultipartEntity entity, String prefix, Collection collection) throws IOException {
        int i = 0;
        for (Object value : collection) {
            String name = String.valueOf(i);
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(entity, tempName, value);
            ++i;
        }
    }

    protected void createEntityIterator(MultipartEntity entity, String prefix, Iterator it) throws IOException {
        int i = 0;
        while (it.hasNext()) {
            Object value = it.next();
            String name = String.valueOf(i);
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(entity, tempName, value);
            ++i;
        }
    }

    protected void createEntityMap(MultipartEntity entity, String prefix, Map map) throws IOException {
        for (Map.Entry entry : map.entrySet()) {
            String name = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            String tempName = StringTools.pathAppend((String)prefix, (String)".", (String)name);
            this.createEntity(entity, tempName, value);
        }
    }

    protected ContentBody createEntityPrimitiveBody(MultipartEntity entity, Object value) throws IOException {
        if (value instanceof File) {
            File file = (File)value;
            return new FileBody(file, "application/octet-stream");
        }
        if (value instanceof FileLocator) {
            File file = ((FileLocator)value).getFile();
            return new FileBody(file, "application/octet-stream");
        }
        if (value instanceof ILocator) {
            return new LocatorBody((ILocator)value);
        }
        if (value instanceof ILocatorSupport) {
            return new LocatorBody(((ILocatorSupport)value).getLocator());
        }
        if (value instanceof byte[]) {
            return new ByteBody((byte[])value);
        }
        return this.createEntityStringBody(entity, value);
    }

    protected ContentBody createEntityStringBody(MultipartEntity entity, Object value) throws IOException {
        String serialized = this.serialize(value);
        Charset charset = StandardCharsets.UTF_8;
        String mimeType = "text/plain";
        return new StringBody(serialized, mimeType, charset);
    }

    @Override
    public String getContentType() {
        return "multipart/form-data";
    }

    protected String serialize(Object value) throws IOException {
        if (value == null) {
            return "";
        }
        if (value instanceof ILocator) {
            return new String(Base64.encode((byte[])LocatorTools.getBytes((ILocator)((ILocator)value))));
        }
        if (value instanceof ILocatorSupport) {
            return new String(Base64.encode((byte[])LocatorTools.getBytes((ILocator)((ILocatorSupport)value).getLocator())));
        }
        if (value instanceof byte[]) {
            return new String(Base64.encode((byte[])((byte[])value)));
        }
        try {
            return (String)ConverterRegistry.get().convert(value, String.class);
        }
        catch (ConversionException e) {
            throw new IOException(e);
        }
    }
}

