/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.logging.logback;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

public class ObjectMapperContext {
    private static ObjectMapper ObjectMapper;

    protected static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        return mapper;
    }

    public static synchronized ObjectMapper getObjectMapper() {
        if (ObjectMapper == null) {
            ObjectMapper = ObjectMapperContext.createObjectMapper();
        }
        return ObjectMapper;
    }

    public static String toString(Object object) {
        try {
            return ObjectMapperContext.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            return "<serialization error>";
        }
    }

    private ObjectMapperContext() {
    }
}

