/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.jackson;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.POJONode;
import de.intarsys.tools.collection.ConversionIterator;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.infoset.AbstractElement;
import de.intarsys.tools.infoset.IAttribute;
import de.intarsys.tools.infoset.IElement;
import de.intarsys.tools.infoset.INode;
import de.intarsys.tools.jackson.JsonAttributeAdapter;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;

public class JsonElementAdapter
extends AbstractElement {
    private final String name;
    private final ContainerNode node;

    public static JsonElementAdapter create(ContainerNode node) {
        if (node == null) {
            return null;
        }
        return new JsonElementAdapter(node);
    }

    public JsonElementAdapter(ContainerNode node) {
        this("root", node);
    }

    public JsonElementAdapter(String name, ContainerNode node) {
        super(node.isArray());
        this.name = name;
        this.node = node;
    }

    public IAttribute attribute(String name) {
        JsonNode childNode = this.getChildNode(name);
        if (childNode == null) {
            return null;
        }
        if (childNode.isContainerNode()) {
            return null;
        }
        return new JsonAttributeAdapter(this, name);
    }

    public Iterator<IAttribute> attributeIterator() {
        if (this.node.isObject()) {
            FilterIterator<Map.Entry<String, JsonNode>> itContainer = new FilterIterator<Map.Entry<String, JsonNode>>(this.node.fields()){

                protected boolean accept(Map.Entry<String, JsonNode> entry) {
                    return entry.getValue().isValueNode();
                }
            };
            return new ConversionIterator<Map.Entry<String, JsonNode>, IAttribute>((Iterator)itContainer){

                protected IAttribute createTargetObject(Map.Entry<String, JsonNode> entry) {
                    return new JsonAttributeAdapter(JsonElementAdapter.this, entry.getKey());
                }
            };
        }
        FilterIterator<JsonNode> itContainer = new FilterIterator<JsonNode>(this.node.elements()){

            protected boolean accept(JsonNode object) {
                return object.isValueNode();
            }
        };
        return new ConversionIterator<JsonNode, IAttribute>((Iterator)itContainer){
            private int index;
            {
                this.index = 0;
            }

            protected IAttribute createTargetObject(JsonNode child) {
                return new JsonAttributeAdapter(JsonElementAdapter.this, String.valueOf(this.index++));
            }
        };
    }

    protected Object basicGetAttributeData(IAttribute attribute, String name) {
        JsonNode value = this.getChildNode(name);
        if (value.isNull()) {
            return null;
        }
        if (value.isShort()) {
            return value.asInt();
        }
        if (value.isInt()) {
            return value.asInt();
        }
        if (value.isLong()) {
            return value.asLong();
        }
        if (value.isFloatingPointNumber()) {
            return value.asDouble();
        }
        if (value.isBoolean()) {
            return value.asBoolean();
        }
        if (value.isPojo()) {
            return ((POJONode)value).getPojo();
        }
        return value.asText();
    }

    protected Object basicGetAttributeRaw(IAttribute attribute, String name) {
        return this.basicGetAttributeData(attribute, name);
    }

    protected String basicGetAttributeValue(IAttribute attribute, String name) {
        JsonNode value = this.getChildNode(name);
        return value.asText();
    }

    protected void basicSetAttributeData(IAttribute attribute, String name, Object data) {
        if (this.node.isObject()) {
            if (data == null) {
                ((ObjectNode)this.node).remove(name);
            } else if (data instanceof Short) {
                ((ObjectNode)this.node).put(name, (Short)data);
            } else if (data instanceof Integer) {
                ((ObjectNode)this.node).put(name, (Integer)data);
            } else if (data instanceof Long) {
                ((ObjectNode)this.node).put(name, (Long)data);
            } else if (data instanceof Double) {
                ((ObjectNode)this.node).put(name, (Double)data);
            } else if (data instanceof Float) {
                ((ObjectNode)this.node).put(name, (Float)data);
            } else if (data instanceof Boolean) {
                ((ObjectNode)this.node).put(name, (Boolean)data);
            } else if (data instanceof String) {
                ((ObjectNode)this.node).put(name, (String)data);
            } else {
                ((ObjectNode)this.node).putPOJO(name, data);
            }
        } else {
            try {
                int index = Integer.parseInt(name);
                if (data == null) {
                    ((ArrayNode)this.node).setNull(index);
                } else if (data instanceof Short) {
                    ((ArrayNode)this.node).set(index, (Short)data);
                } else if (data instanceof Integer) {
                    ((ArrayNode)this.node).set(index, (Integer)data);
                } else if (data instanceof Long) {
                    ((ArrayNode)this.node).set(index, (Long)data);
                } else if (data instanceof Double) {
                    ((ArrayNode)this.node).set(index, (Double)data);
                } else if (data instanceof Float) {
                    ((ArrayNode)this.node).set(index, (Float)data);
                } else if (data instanceof Boolean) {
                    ((ArrayNode)this.node).set(index, (Boolean)data);
                } else if (data instanceof String) {
                    ((ArrayNode)this.node).set(index, (String)data);
                } else {
                    ((ArrayNode)this.node).setPOJO(index, data);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    protected void basicSetAttributeRaw(IAttribute attribute, String name, Object raw) {
        this.basicSetAttributeData(attribute, name, raw);
    }

    protected void basicSetAttributeValue(IAttribute attribute, String name, String value) {
        if (this.node.isObject()) {
            if (value == null) {
                ((ObjectNode)this.node).remove(name);
            } else {
                ((ObjectNode)this.node).put(name, value);
            }
        } else {
            try {
                int index = Integer.parseInt(name);
                ((ArrayNode)this.node).set(index, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public IElement element(String name) {
        JsonNode childNode = this.getChildNode(name);
        if (childNode == null) {
            return null;
        }
        if (childNode.isContainerNode()) {
            return new JsonElementAdapter(name, (ContainerNode)childNode);
        }
        return null;
    }

    public Iterator<IElement> elementIterator() {
        if (this.node.isObject()) {
            FilterIterator<Map.Entry<String, JsonNode>> itChildren = new FilterIterator<Map.Entry<String, JsonNode>>(this.node.fields()){

                protected boolean accept(Map.Entry<String, JsonNode> entry) {
                    return entry.getValue().isContainerNode();
                }
            };
            return new ConversionIterator<Map.Entry<String, JsonNode>, IElement>((Iterator)itChildren){

                protected IElement createTargetObject(Map.Entry<String, JsonNode> entry) {
                    return new JsonElementAdapter(entry.getKey(), (ContainerNode)entry.getValue());
                }
            };
        }
        FilterIterator<JsonNode> itChildren = new FilterIterator<JsonNode>(this.node.elements()){

            protected boolean accept(JsonNode object) {
                return object.isContainerNode();
            }
        };
        return new ConversionIterator<JsonNode, IElement>((Iterator)itChildren){
            private int index;
            {
                this.index = 0;
            }

            protected IElement createTargetObject(JsonNode child) {
                return new JsonElementAdapter(String.valueOf(this.index++), (ContainerNode)child);
            }
        };
    }

    protected JsonNode getChildNode(String name) {
        Object childNode = null;
        if (this.node.isObject()) {
            return this.node.get(name);
        }
        try {
            int index = Integer.parseInt(name);
            return this.node.get(index);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public String getName() {
        return this.name;
    }

    public IAttribute newAttribute(String name) {
        if (this.node.isObject()) {
            Objects.requireNonNull(name, "name cannot be null");
            ((ObjectNode)this.node).putNull(name);
            return new JsonAttributeAdapter(this, name);
        }
        ((ArrayNode)this.node).addNull();
        return new JsonAttributeAdapter(this, Integer.toString(((ArrayNode)this.node).size() - 1));
    }

    public IElement newElementIndexed(String name) {
        if (this.node.isObject()) {
            Objects.requireNonNull(name, "name cannot be null");
            return new JsonElementAdapter(name, (ContainerNode)((ObjectNode)this.node).putArray(name));
        }
        return new JsonElementAdapter(name, (ContainerNode)((ArrayNode)this.node).addArray());
    }

    public IElement newElementMapped(String name) {
        if (this.node.isObject()) {
            Objects.requireNonNull(name, "name cannot be null");
            return new JsonElementAdapter(name, (ContainerNode)((ObjectNode)this.node).putObject(name));
        }
        return new JsonElementAdapter(name, (ContainerNode)((ArrayNode)this.node).addObject());
    }

    public Iterator<INode> nodeIterator() {
        if (this.node.isObject()) {
            return new ConversionIterator<Map.Entry<String, JsonNode>, INode>(this.node.fields()){

                protected INode createTargetObject(Map.Entry<String, JsonNode> entry) {
                    JsonNode child = entry.getValue();
                    if (child.isContainerNode()) {
                        return new JsonElementAdapter(entry.getKey(), (ContainerNode)child);
                    }
                    return new JsonAttributeAdapter(JsonElementAdapter.this, entry.getKey());
                }
            };
        }
        return new ConversionIterator<JsonNode, INode>(this.node.elements()){
            private int index;
            {
                this.index = 0;
            }

            protected INode createTargetObject(JsonNode child) {
                if (child.isContainerNode()) {
                    return new JsonElementAdapter(String.valueOf(this.index++), (ContainerNode)child);
                }
                return new JsonAttributeAdapter(JsonElementAdapter.this, String.valueOf(this.index++));
            }
        };
    }

    public void nodeRemove(String name) {
        if (this.node.isObject()) {
            ((ObjectNode)this.node).remove(name);
        } else {
            try {
                int index = Integer.parseInt(name);
                ((ArrayNode)this.node).remove(index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }
}

