/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.signature.attribute.ICertificateValuesAttribute;
import de.intarsys.security.signature.attribute.impl.CertificateValuesAttribute;
import de.intarsys.tools.encoding.Base64;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CertificateValuesDecoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "UnsignedProperties/UnsignedSignatureProperties/CertificateValues";

    public ICertificateValuesAttribute decodeAttribute(Element certificateValues) throws IOException {
        NodeList encapCertNodeList = certificateValues.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "EncapsulatedX509Certificate");
        ArrayList<IX509PublicKeyCertificate> result = new ArrayList<IX509PublicKeyCertificate>(encapCertNodeList.getLength());
        for (int i = 0; i < encapCertNodeList.getLength(); ++i) {
            String base64Value = encapCertNodeList.item(i).getTextContent();
            byte[] derCert = Base64.decode((String)base64Value);
            try {
                IX509PublicKeyCertificate cert = X509CertificateFactory.get().createPublicKeyCertificate(derCert);
                result.add(cert);
                continue;
            }
            catch (CertificateException e) {
                throw new IOException(e.getLocalizedMessage(), e);
            }
        }
        IX509PublicKeyCertificate[] certificates = result.toArray(new IX509PublicKeyCertificate[result.size()]);
        return new CertificateValuesAttribute(certificates);
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.23";
    }
}

