/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.security.crl.IX509CRL;
import de.intarsys.security.crl.common.X509CRL;
import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPResponse;
import de.intarsys.security.ocsp.common.OCSPTools;
import de.intarsys.security.signature.attribute.IRevocationValuesAttribute;
import de.intarsys.security.signature.attribute.impl.RevocationValuesAttribute;
import de.intarsys.tools.encoding.Base64;
import java.io.IOException;
import java.security.cert.CRLException;
import java.util.ArrayList;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ocsp.BasicOCSPResponse;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RevocationValuesDecoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "UnsignedProperties/UnsignedSignatureProperties/RevocationValues";

    protected IOCSPResponse decode(Node encapsulatedOCSPValue) throws IOException {
        String base64Value = encapsulatedOCSPValue.getTextContent();
        byte[] derOCSP = Base64.decode((String)base64Value);
        ASN1Primitive object = ASN1Tools.create((byte[])derOCSP);
        if (object instanceof ASN1Sequence && ((ASN1Sequence)object).size() > 2) {
            BasicOCSPResponse basicOcsp = BasicOCSPResponse.getInstance((Object)object);
            return new OCSPResponse(new BasicOCSPResp(basicOcsp));
        }
        return OCSPTools.decodeOCSPResponse((org.bouncycastle.asn1.ocsp.OCSPResponse)org.bouncycastle.asn1.ocsp.OCSPResponse.getInstance((Object)object));
    }

    public IRevocationValuesAttribute decodeAttribute(Element revocationValues) throws IOException {
        NodeList crlValuesList = revocationValues.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "CRLValues");
        IX509CRL[] crls = this.getX509CRLs(crlValuesList);
        NodeList ocspValuesList = revocationValues.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "OCSPValues");
        IOCSPResponse[] ocsps = this.getOCSPs(ocspValuesList);
        return new RevocationValuesAttribute(crls, ocsps);
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    private IOCSPResponse[] getOCSPs(NodeList ocspValuesList) throws IOException {
        ArrayList<IOCSPResponse> result = new ArrayList<IOCSPResponse>(ocspValuesList.getLength());
        for (int i = 0; i < ocspValuesList.getLength(); ++i) {
            Element crlValue = (Element)ocspValuesList.item(i);
            NodeList encapsulatedOCSPValues = crlValue.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "EncapsulatedOCSPValue");
            for (int j = 0; j < encapsulatedOCSPValues.getLength(); ++j) {
                Node encapsulatedOCSPValue = encapsulatedOCSPValues.item(j);
                IOCSPResponse ocspResponse = this.decode(encapsulatedOCSPValue);
                result.add(ocspResponse);
            }
        }
        return result.toArray(new IOCSPResponse[result.size()]);
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.24";
    }

    private IX509CRL[] getX509CRLs(NodeList crlValuesList) throws IOException {
        ArrayList<X509CRL> result = new ArrayList<X509CRL>(crlValuesList.getLength());
        for (int i = 0; i < crlValuesList.getLength(); ++i) {
            Element crlValue = (Element)crlValuesList.item(i);
            NodeList encapsulatedCrlValues = crlValue.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "EncapsulatedCRLValue");
            for (int j = 0; j < encapsulatedCrlValues.getLength(); ++j) {
                String base64Value = encapsulatedCrlValues.item(j).getTextContent();
                byte[] derCRL = Base64.decode((String)base64Value);
                try {
                    CertificateList certificateList = CertificateList.getInstance((Object)ASN1Tools.create((byte[])derCRL));
                    result.add(new X509CRL(certificateList));
                    continue;
                }
                catch (CRLException e) {
                    throw new IOException(e.getLocalizedMessage(), e);
                }
            }
        }
        return result.toArray(new IX509CRL[result.size()]);
    }
}

