/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.security.signature.attribute.ISignaturePolicyIdentifierAttribute;
import de.intarsys.security.signature.attribute.impl.SignaturePolicyIdentifierAttribute;
import de.intarsys.security.signature.policy.IPolicyId;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.IQualifier;
import de.intarsys.security.signature.policy.ImpliedPolicy;
import de.intarsys.security.signature.policy.PolicyId;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.dom.DOMTools;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Element;

public class SignaturePolicyIdentifierDecoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "SignedProperties/SignedSignatureProperties/SignaturePolicyIdentifier";

    protected ISignaturePolicyIdentifierAttribute decodeAttribute(Element eSignaturePolicyIdentifier) throws IOException {
        ImpliedPolicy policyRef = null;
        Element eSignaturePolicyImplied = DOMTools.getElementFirst((Element)eSignaturePolicyIdentifier, (String)"SignaturePolicyImplied");
        if (eSignaturePolicyImplied == null) {
            Element eSignaturePolicyId = DOMTools.getElementFirst((Element)eSignaturePolicyIdentifier, (String)"SignaturePolicyId");
            policyRef = this.decodeSignaturePolicyId(eSignaturePolicyId);
        } else {
            policyRef = ImpliedPolicy.INSTANCE;
        }
        return new SignaturePolicyIdentifierAttribute((IPolicyReference)policyRef);
    }

    protected IPolicyId decodeSignaturePolicyId(Element eSignaturePolicyId) throws IOException {
        Element eSigPolicyId = DOMTools.getElementFirst((Element)eSignaturePolicyId, (String)"SigPolicyId");
        String policyOid = XMLDSigMarshaller.get().decodeObjectIdentifier(eSigPolicyId);
        PolicyId policyId = new PolicyId(policyOid);
        Element eSigPolicyHash = DOMTools.getElementFirst((Element)eSignaturePolicyId, (String)"SigPolicyHash");
        IDigest digest = XMLDSigMarshaller.get().decodeDigestAlgAndValue(eSigPolicyHash);
        policyId.setDigest(digest);
        Element eSigPolicyQualifiers = DOMTools.getElementFirst((Element)eSignaturePolicyId, (String)"SigPolicyQualifiers");
        if (eSigPolicyQualifiers != null) {
            List eSigPolicyQualifierList = DOMTools.getElements((Element)eSigPolicyQualifiers, (String)"SigPolicyQualifier");
            for (Element eSigPolicyQualifier : eSigPolicyQualifierList) {
                IQualifier qualifier = XMLDSigMarshaller.get().decodeQualifier(eSigPolicyQualifier);
                policyId.addQualifier(qualifier);
            }
        }
        return policyId;
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.15";
    }
}

