/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.method.cms.signature.CMSSignature;
import de.intarsys.security.method.cms.timestamp.TimestampToken;
import de.intarsys.security.method.xml.attribute.decoder.CommonXMLAttributeDecoder;
import de.intarsys.security.signature.attribute.ISignatureTimestampAttribute;
import de.intarsys.security.signature.attribute.impl.SignatureTimestampAttribute;
import de.intarsys.security.timestamp.ITimestampToken;
import de.intarsys.tools.encoding.Base64;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SignatureTimeStampDecoder
extends CommonXMLAttributeDecoder {
    private static final String NODE_PATH = "UnsignedProperties/UnsignedSignatureProperties/SignatureTimeStamp";

    protected ISignatureTimestampAttribute decodeAttribute(List<Element> eAttributes) throws IOException {
        ITimestampToken[] timestamps = new ITimestampToken[eAttributes.size()];
        int index = 0;
        for (Element signatureTimestamp : eAttributes) {
            ITimestampToken timestamp = null;
            NodeList encapsulatedTimeStampNodes = signatureTimestamp.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "EncapsulatedTimeStamp");
            NodeList xmlTimeStampNodes = signatureTimestamp.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "XMLTimeStamp");
            if (encapsulatedTimeStampNodes.getLength() > 0) {
                timestamp = this.loadEncapsulatedTimeStamp((Element)encapsulatedTimeStampNodes.item(0));
            } else if (xmlTimeStampNodes.getLength() > 0) {
                timestamp = this.loadXMLTimeStamp((Element)xmlTimeStampNodes.item(0));
            } else {
                throw new IOException("could not load timestamp - element didn't container the required data");
            }
            timestamps[index++] = timestamp;
        }
        return new SignatureTimestampAttribute(timestamps);
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.14";
    }

    private ITimestampToken loadEncapsulatedTimeStamp(Element element) throws IOException {
        String base64Value = element.getTextContent();
        byte[] derTimestamp = Base64.decode((String)base64Value);
        return TimestampToken.create((CMSSignature)new CMSSignature(derTimestamp));
    }

    private ITimestampToken loadXMLTimeStamp(Element item) throws IOException {
        throw new IOException("XML timestamps are not supported");
    }
}

