/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.security.signature.attribute.ISignerAttributesAttribute;
import de.intarsys.security.signature.attribute.impl.SignerAttributesAttribute;
import de.intarsys.tools.dom.DOMTools;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class SignerRoleDecoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "SignedProperties/SignedSignatureProperties/SignerRole";

    public ISignerAttributesAttribute decodeAttribute(Element eAttribute) throws IOException {
        IX509AttributeCertificate[] attributeCertificates;
        try {
            attributeCertificates = this.decodeAttributeCertificates(eAttribute);
        }
        catch (CertificateException | DOMException e) {
            throw new IOException(e);
        }
        IX509Attribute[] claimedAttributes = this.decodeClaimedAttributes(eAttribute);
        return new SignerAttributesAttribute(attributeCertificates, claimedAttributes);
    }

    protected IX509AttributeCertificate[] decodeAttributeCertificates(Element eAttribute) throws IOException, CertificateException, DOMException {
        Element eCertifiedRoles = DOMTools.getElementFirst((Element)eAttribute, (String)"CertifiedRoles");
        if (eCertifiedRoles == null) {
            return new IX509AttributeCertificate[0];
        }
        List eCertifiedRoleList = DOMTools.getElements((Element)eCertifiedRoles, (String)"CertifiedRole");
        IX509AttributeCertificate[] result = new IX509AttributeCertificate[eCertifiedRoleList.size()];
        int i = 0;
        for (Element eCertifiedRole : eCertifiedRoleList) {
            result[i++] = XMLDSigMarshaller.get().decodeEncapsulatedPKIDataTypeAttributeCertificate(eCertifiedRole);
        }
        return result;
    }

    protected IX509Attribute[] decodeClaimedAttributes(Element eAttribute) throws IOException {
        Element eClaimedRoles = DOMTools.getElementFirst((Element)eAttribute, (String)"ClaimedRoles");
        if (eClaimedRoles == null) {
            return new IX509Attribute[0];
        }
        return new IX509Attribute[0];
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.18";
    }
}

