/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.certificate.IX509Attribute;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.security.signature.attribute.ISignerAttributesV2Attribute;
import de.intarsys.security.signature.attribute.impl.SignerAttributesV2Attribute;
import de.intarsys.tools.dom.DOMTools;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class SignerRoleV2Decoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "SignedProperties/SignedSignatureProperties/SignerRoleV2";

    public ISignerAttributesV2Attribute decodeAttribute(Element eAttribute) throws IOException {
        IX509AttributeCertificate[] attributeCertificates;
        try {
            attributeCertificates = this.decodeAttributeCertificates(eAttribute);
        }
        catch (CertificateException | DOMException e) {
            throw new IOException(e);
        }
        IX509Attribute[] claimedAttributes = this.decodeClaimedAttributes(eAttribute);
        return new SignerAttributesV2Attribute(attributeCertificates, claimedAttributes);
    }

    protected IX509AttributeCertificate[] decodeAttributeCertificates(Element eAttribute) throws IOException, CertificateException, DOMException {
        Element eCertifiedRolesV2 = DOMTools.getElementFirst((Element)eAttribute, (String)"CertifiedRolesV2");
        if (eCertifiedRolesV2 == null) {
            return new IX509AttributeCertificate[0];
        }
        List eCertifiedRoleList = DOMTools.getElements((Element)eCertifiedRolesV2, (String)"CertifiedRole");
        ArrayList<IX509AttributeCertificate> result = new ArrayList<IX509AttributeCertificate>();
        for (Element eCertifiedRole : eCertifiedRoleList) {
            Element eX509AttributeCertificate = DOMTools.getElementFirst((Element)eCertifiedRole, (String)"X509AttributeCertificate");
            if (eX509AttributeCertificate == null) continue;
            result.add(XMLDSigMarshaller.get().decodeEncapsulatedPKIDataTypeAttributeCertificate(eX509AttributeCertificate));
        }
        return result.toArray(new IX509AttributeCertificate[result.size()]);
    }

    protected IX509Attribute[] decodeClaimedAttributes(Element eAttribute) throws IOException {
        Element eClaimedRoles = DOMTools.getElementFirst((Element)eAttribute, (String)"ClaimedRoles");
        if (eClaimedRoles == null) {
            return new IX509Attribute[0];
        }
        return new IX509Attribute[0];
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "0.4.0.19122.1.1";
    }
}

