/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.security.signature.attribute.ISigningCertificate;
import de.intarsys.security.signature.attribute.ISigningCertificateAttribute;
import de.intarsys.security.signature.attribute.impl.SigningCertificate;
import de.intarsys.security.signature.attribute.impl.SigningCertificateAttribute;
import de.intarsys.tools.digest.IDigest;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SigningCertificateDecoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "SignedProperties/SignedSignatureProperties/SigningCertificate";

    public ISigningCertificateAttribute decodeAttribute(Element signingCertElement) throws IOException {
        IDigest digest = null;
        X509IssuerSerial x509IssuerSerial = null;
        NodeList certNodes = signingCertElement.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "Cert");
        int numNodes = certNodes.getLength();
        if (numNodes == 0) {
            return null;
        }
        ArrayList<SigningCertificate> signingCerts = new ArrayList<SigningCertificate>(numNodes);
        for (int i = 0; i < certNodes.getLength(); ++i) {
            Element cert = (Element)certNodes.item(i);
            NodeList certDigestNodes = cert.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "CertDigest");
            if (certDigestNodes.getLength() <= 0) {
                throw new IOException("element 'CertDigest' is required");
            }
            digest = XMLDSigMarshaller.get().decodeDigestAlgAndValue((Element)certDigestNodes.item(0));
            NodeList issuerSerialNodes = cert.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "IssuerSerial");
            if (issuerSerialNodes.getLength() <= 0) {
                throw new IOException("element 'IssuerSerial' is required");
            }
            x509IssuerSerial = this.loadX509IssuerSerial((Element)issuerSerialNodes.item(0));
            signingCerts.add(new SigningCertificate(x509IssuerSerial.getIssuerName(), x509IssuerSerial.getSerialNumber(), digest));
        }
        return new SigningCertificateAttribute(signingCerts.toArray(new ISigningCertificate[signingCerts.size()]));
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.12";
    }

    private X509IssuerSerial loadX509IssuerSerial(Element issuerSerial) throws IOException {
        NodeList x509IssuerNameNodes = issuerSerial.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509IssuerName");
        if (x509IssuerNameNodes.getLength() <= 0) {
            throw new IOException("element 'X509IssuerName' is required");
        }
        String x509IssuerName = x509IssuerNameNodes.item(0).getTextContent();
        NodeList x509SerialNumberNodes = issuerSerial.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "X509SerialNumber");
        if (x509SerialNumberNodes.getLength() <= 0) {
            throw new IOException("element 'X509SerialNumber' is required");
        }
        String x509SerialNumberString = x509SerialNumberNodes.item(0).getTextContent();
        BigInteger x509SerialNumber = new BigInteger(x509SerialNumberString);
        return new X509IssuerSerial(x509IssuerName, x509SerialNumber);
    }

    public class X509IssuerSerial {
        private final String issuerName;
        private final BigInteger serialNumber;

        public X509IssuerSerial(String issuerName, BigInteger serialNumber) {
            assert (issuerName != null);
            assert (serialNumber != null);
            this.issuerName = issuerName;
            this.serialNumber = serialNumber;
        }

        public String getIssuerName() {
            return this.issuerName;
        }

        public BigInteger getSerialNumber() {
            return this.serialNumber;
        }
    }
}

