/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.asn1.common.GeneralNames;
import de.intarsys.asn1.model.ASN1Tools;
import de.intarsys.asn1.x509.attr.IssuerSerial;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.security.signature.attribute.ISigningCertificate;
import de.intarsys.security.signature.attribute.ISigningCertificateAttribute;
import de.intarsys.security.signature.attribute.impl.SigningCertificate;
import de.intarsys.security.signature.attribute.impl.SigningCertificateAttribute;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SigningCertificateV2Decoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "SignedProperties/SignedSignatureProperties/SigningCertificateV2";

    protected ISigningCertificate createSigningCertificate(Element cert) throws IOException {
        IDigest digest = null;
        IssuerSerial issuerSerial = null;
        NodeList certDigestNodes = cert.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "CertDigest");
        if (certDigestNodes.getLength() <= 0) {
            throw new IOException("element 'CertDigest' is required");
        }
        digest = XMLDSigMarshaller.get().decodeDigestAlgAndValue((Element)certDigestNodes.item(0));
        NodeList issuerSerialNodes = cert.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "IssuerSerialV2");
        if (issuerSerialNodes.getLength() > 0) {
            issuerSerial = this.loadIssuerSerial((Element)issuerSerialNodes.item(0));
        }
        String issuerName = null;
        BigInteger serialNumber = null;
        if (issuerSerial != null) {
            serialNumber = issuerSerial.getSerial().getValue();
            issuerName = this.getIssuerName(issuerSerial);
        }
        return new SigningCertificate(issuerName, serialNumber, digest);
    }

    public ISigningCertificateAttribute decodeAttribute(Element signingCertElement) throws IOException {
        NodeList certNodes = signingCertElement.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", "Cert");
        int numNodes = certNodes.getLength();
        if (numNodes == 0) {
            return null;
        }
        ArrayList<ISigningCertificate> signingCerts = new ArrayList<ISigningCertificate>(numNodes);
        for (int i = 0; i < certNodes.getLength(); ++i) {
            Element cert = (Element)certNodes.item(i);
            ISigningCertificate signingCertificate = this.createSigningCertificate(cert);
            signingCerts.add(signingCertificate);
        }
        return new SigningCertificateAttribute(signingCerts.toArray(new ISigningCertificate[signingCerts.size()]));
    }

    protected String getIssuerName(IssuerSerial issuerSerial) {
        X500Principal issuerPrincipal;
        try {
            issuerPrincipal = CertificateTools.parsePrincipal((GeneralNames)issuerSerial.getIssuer());
        }
        catch (IOException e) {
            return null;
        }
        if (issuerPrincipal != null) {
            return issuerPrincipal.toString();
        }
        return null;
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.16.2.47";
    }

    private IssuerSerial loadIssuerSerial(Element issuerSerialElement) throws IOException {
        String base64IssuerSerial = issuerSerialElement.getTextContent();
        if (StringTools.isEmpty((String)base64IssuerSerial)) {
            throw new IOException("element text content missong");
        }
        byte[] derIssuerSerial = Base64.decode((String)base64IssuerSerial);
        IssuerSerial issuerSerial = (IssuerSerial)IssuerSerial.FACTORY.create((ASN1Encodable)ASN1Tools.create((byte[])derIssuerSerial));
        return issuerSerial;
    }
}

