/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.method.xml.attribute.decoder.SingleValueXMLAttributeDecoder;
import de.intarsys.security.signature.attribute.ISigningTimeAttribute;
import de.intarsys.security.signature.attribute.impl.SigningTimeAttribute;
import java.io.IOException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.w3c.dom.Element;

public class SigningTimeDecoder
extends SingleValueXMLAttributeDecoder {
    private static final String NODE_PATH = "SignedProperties/SignedSignatureProperties/SigningTime";

    public ISigningTimeAttribute decodeAttribute(Element signingTime) throws IOException {
        XMLGregorianCalendar xmlGCal;
        String dateTime = signingTime.getTextContent();
        try {
            xmlGCal = DatatypeFactory.newInstance().newXMLGregorianCalendar(dateTime);
        }
        catch (DatatypeConfigurationException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        return new SigningTimeAttribute(xmlGCal.toGregorianCalendar().getTime());
    }

    @Override
    public String getNodePath() {
        return NODE_PATH;
    }

    public String getOID() {
        return "1.2.840.113549.1.9.5";
    }
}

