/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.decoder;

import de.intarsys.security.method.xml.attribute.decoder.CertificateValuesDecoder;
import de.intarsys.security.method.xml.attribute.decoder.CommitmentTypeIndicationDecoder;
import de.intarsys.security.method.xml.attribute.decoder.IXMLAttributeDecoder;
import de.intarsys.security.method.xml.attribute.decoder.RevocationValuesDecoder;
import de.intarsys.security.method.xml.attribute.decoder.SignaturePolicyIdentifierDecoder;
import de.intarsys.security.method.xml.attribute.decoder.SignatureTimeStampDecoder;
import de.intarsys.security.method.xml.attribute.decoder.SignerRoleDecoder;
import de.intarsys.security.method.xml.attribute.decoder.SignerRoleV2Decoder;
import de.intarsys.security.method.xml.attribute.decoder.SigningCertificateDecoder;
import de.intarsys.security.method.xml.attribute.decoder.SigningCertificateV2Decoder;
import de.intarsys.security.method.xml.attribute.decoder.SigningTimeDecoder;
import de.intarsys.security.signature.attribute.AttributeCodecRegistry;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.tools.component.SingletonClass;
import java.util.HashMap;
import java.util.Map;

@SingletonClass
public class WellKnownAttributes {
    private static final WellKnownAttributes ACTIVE = new WellKnownAttributes();
    private final Map<String, String> oid2NodePath = new HashMap<String, String>();
    private final AttributeCodecRegistry registry = new AttributeCodecRegistry();

    public static WellKnownAttributes get() {
        return ACTIVE;
    }

    private WellKnownAttributes() {
        this.registerDecoder();
    }

    public IAttributeDecoder lookupDecoder(String type) {
        return this.registry.lookupDecoder(type);
    }

    public String mapNodePath2OID(String nodePath) {
        for (Map.Entry<String, String> entry : this.oid2NodePath.entrySet()) {
            if (!nodePath.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    public String mapOID2NodePath(String oid) {
        return this.oid2NodePath.get(oid);
    }

    private void registerDecoder() {
        this.registerDecoder(new SignatureTimeStampDecoder());
        this.registerDecoder(new SigningTimeDecoder());
        this.registerDecoder(new SigningCertificateDecoder());
        this.registerDecoder(new SigningCertificateV2Decoder());
        this.registerDecoder(new RevocationValuesDecoder());
        this.registerDecoder(new CertificateValuesDecoder());
        this.registerDecoder(new SignaturePolicyIdentifierDecoder());
        this.registerDecoder(new CommitmentTypeIndicationDecoder());
        this.registerDecoder(new SignerRoleDecoder());
        this.registerDecoder(new SignerRoleV2Decoder());
    }

    public void registerDecoder(IXMLAttributeDecoder decoder) {
        this.oid2NodePath.put(decoder.getOID(), decoder.getNodePath());
        this.registry.registerDecoder((IAttributeDecoder)decoder);
    }
}

