/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.xml.attribute.encoder.UnsignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XAdESMarshaller;
import de.intarsys.security.method.xml.signature.XMLSignatureEntry;
import de.intarsys.security.method.xml.spec.XAdESBaseline;
import de.intarsys.security.method.xml.validation.XMLValidationDataExtender;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import jakarta.xml.bind.JAXBElement;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.etsi.uri._01903.v1_3.CertificateValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.w3c.dom.Element;

public class CertificateValuesEncoder
extends UnsignedPropertyEncoder {
    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory factory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        IExtendedValidationData extendedValidationData = XMLValidationDataExtender.getExtendedValidationData(context);
        XMLSignatureEntry entry = XMLValidationDataExtender.getSignatureEntry(context);
        List<IX509PublicKeyCertificate> certificates = entry.getCertificates();
        try {
            CertificateValuesType value = new CertificateValuesType();
            extendedValidationData.getCertificates().filter(certificate -> !certificates.contains(certificate)).forEach(certificate -> {
                try {
                    byte[] encoded = certificate.getEncoded();
                    EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
                    encapsulated.setValue(encoded);
                    encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
                    value.getEncapsulatedX509CertificateOrOtherCertificate().add(encapsulated);
                }
                catch (CertificateEncodingException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, MarshalException.class);
                }
            });
            if (value.getEncapsulatedX509CertificateOrOtherCertificate().isEmpty()) {
                return;
            }
            JAXBElement jaxb = XAdESBaseline.OF_1_3.createCertificateValues(value);
            XAdESMarshaller.get().marshal(parentSupplier.get(), jaxb);
        }
        catch (Exception e) {
            throw (MarshalException)ExceptionTools.unwrapTypedFromChain((Throwable)e, MarshalException.class);
        }
    }
}

