/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.method.xml.attribute.encoder.UnsignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XAdESMarshaller;
import de.intarsys.security.method.xml.spec.XAdESBaseline;
import de.intarsys.security.method.xml.validation.XMLValidationDataExtender;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPTools;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.w3c.dom.Element;

public class RevocationValuesEncoder
extends UnsignedPropertyEncoder {
    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory factory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        IExtendedValidationData extendedValidationData = XMLValidationDataExtender.getExtendedValidationData(context);
        try {
            RevocationValuesType revocationValues = new RevocationValuesType();
            OCSPValuesType ocspValues = new OCSPValuesType();
            CRLValuesType crlValues = new CRLValuesType();
            extendedValidationData.getOCSPResponses().forEach(ocsp -> {
                try {
                    byte[] encoded;
                    try {
                        encoded = OCSPTools.encodeAsn1OcspResponse((IOCSPResponse)ocsp);
                    }
                    catch (IOException e) {
                        throw new MarshalException(e);
                    }
                    EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
                    encapsulated.setValue(encoded);
                    encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
                    ocspValues.getEncapsulatedOCSPValue().add(encapsulated);
                }
                catch (Exception e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, MarshalException.class);
                }
            });
            if (!ocspValues.getEncapsulatedOCSPValue().isEmpty()) {
                revocationValues.setOCSPValues(ocspValues);
            }
            extendedValidationData.getCRLs().forEach(crl -> {
                try {
                    byte[] encoded = crl.getEncoded();
                    EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
                    encapsulated.setValue(encoded);
                    encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
                    crlValues.getEncapsulatedCRLValue().add(encapsulated);
                }
                catch (Exception e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, MarshalException.class);
                }
            });
            if (!crlValues.getEncapsulatedCRLValue().isEmpty()) {
                revocationValues.setCRLValues(crlValues);
            }
            if (ocspValues.getEncapsulatedOCSPValue().isEmpty() && crlValues.getEncapsulatedCRLValue().isEmpty()) {
                return;
            }
            JAXBElement jaxb = XAdESBaseline.OF_1_3.createRevocationValues(revocationValues);
            XAdESMarshaller.get().marshal(parentSupplier.get(), jaxb);
        }
        catch (Exception e) {
            throw (MarshalException)ExceptionTools.unwrapTypedFromChain((Throwable)e, MarshalException.class);
        }
    }
}

