/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.method.xml.attribute.encoder.SignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XAdESMarshaller;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.security.signature.policy.IImpliedPolicy;
import de.intarsys.security.signature.policy.IPolicy;
import de.intarsys.security.signature.policy.IPolicyId;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.IQualifier;
import de.intarsys.security.signature.policy.PolicyTools;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.dom.DOMTools;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignaturePolicyIdentifierEncoder
extends SignedPropertyEncoder {
    private String digestAlgorithm = "SHA-256";
    private IPolicyReference policyReference;

    public SignaturePolicyIdentifierEncoder(IPolicyReference policyReference) {
        this.policyReference = policyReference;
    }

    protected IDigest calculateDigest(IPolicy policy) throws IOException {
        IDigester digester;
        byte[] digestInput = null;
        if ("xml".equals(policy.getEncoding())) {
            // empty if block
        }
        if (digestInput == null) {
            digestInput = policy.getEncoded();
        }
        try {
            digester = DigestTools.createDigester((String)this.getDigestAlgorithm());
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e);
        }
        IDigest digest = digester.digest(digestInput);
        return digest;
    }

    protected Element createSignaturePolicyIdElement(XMLCryptoContext context, Node parent, IPolicyId policyId) throws DOMException, MarshalException {
        IDigest digest;
        Element eSignaturePolicyId = DOMTools.createChild((Node)parent, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SignaturePolicyId");
        Element eSigPolicyId = DOMTools.createChild((Node)eSignaturePolicyId, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SigPolicyId");
        XAdESMarshaller.get().marshalObjectIdentifierType(context, eSigPolicyId, policyId.getOID());
        Element eSigPolicyHash = DOMTools.createChild((Node)eSignaturePolicyId, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SigPolicyHash");
        IPolicy policy = PolicyTools.lookupPolicy((IPolicyId)policyId);
        if (policy == null) {
            throw new MarshalException("Policy not avalable.");
        }
        try {
            digest = this.calculateDigest(policy);
        }
        catch (IOException e) {
            throw new MarshalException(e);
        }
        if (policyId.getDigest() != null && !policyId.getDigest().equals(digest)) {
            throw new MarshalException("Calculated hash value does not match the externally passed hash value. Expected:" + policyId.getDigest() + ", calculated: " + digest);
        }
        XMLDSigMarshaller.get().marshalDigestAlgAndValue(context, eSigPolicyHash, digest);
        if (!policyId.getQualifiers().isEmpty()) {
            Element eSigPolicyQualifiers = DOMTools.createChild((Node)eSignaturePolicyId, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SigPolicyQualifiers");
            for (IQualifier qualifier : policyId.getQualifiers()) {
                Element eSigPolicyQualifier = DOMTools.createChild((Node)eSigPolicyQualifiers, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SigPolicyQualifier");
                XMLDSigMarshaller.get().marshalQualifier(context, eSigPolicyQualifier, qualifier);
            }
        }
        return eSignaturePolicyId;
    }

    protected Element createSignaturePolicyIdentifierElement(XMLCryptoContext context, Supplier<Element> parentSupplier, IPolicyReference policyReference) throws DOMException, MarshalException {
        Element eSignaturePolicyIdentifier = DOMTools.createChild((Node)parentSupplier.get(), (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SignaturePolicyIdentifier");
        if (policyReference instanceof IPolicyId) {
            this.createSignaturePolicyIdElement(context, eSignaturePolicyIdentifier, (IPolicyId)policyReference);
        } else if (policyReference instanceof IImpliedPolicy) {
            this.createSignaturePolicyImpliedElement(context, eSignaturePolicyIdentifier, (IImpliedPolicy)policyReference);
        } else {
            throw new MarshalException("Unsupported policy reference type");
        }
        return eSignaturePolicyIdentifier;
    }

    protected Element createSignaturePolicyImpliedElement(XMLCryptoContext context, Node parent, IImpliedPolicy impliedPolicy) throws DOMException {
        return DOMTools.createChild((Node)parent, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SignaturePolicyImplied");
    }

    public String getDigestAlgorithm() {
        return this.digestAlgorithm;
    }

    public IPolicyReference getPolicyReference() {
        return this.policyReference;
    }

    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory xmlSignatureFactory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        this.createSignaturePolicyIdentifierElement(context, parentSupplier, this.getPolicyReference());
    }

    public void setDigestAlgorithm(String digestAlgorithm) {
        this.digestAlgorithm = digestAlgorithm;
    }
}

