/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.timestamp.ITimestampRequest;
import de.intarsys.security.app.timestamp.ITimestampResponse;
import de.intarsys.security.app.timestamp.PlainTimestampRequest;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.method.xml.attribute.encoder.UnsignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XAdESMarshaller;
import de.intarsys.security.method.xml.spec.XAdESBaseline;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.dom.DOMTools;
import jakarta.xml.bind.JAXBElement;
import java.io.InputStream;
import java.util.function.Supplier;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.OctetStreamData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import org.apache.jcp.xml.dsig.internal.dom.DOMSubTreeData;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.XAdESTimeStampType;
import org.w3._2000._09.xmldsig.CanonicalizationMethodType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignatureTimeStampEncoder
extends UnsignedPropertyEncoder {
    private ITimestampCreator timestampCreator;
    private String c14nAlgorithm = "http://www.w3.org/TR/2001/REC-xml-c14n-20010315";
    private boolean enforceTimestamp;

    public SignatureTimeStampEncoder() {
    }

    public SignatureTimeStampEncoder(ITimestampCreator service) {
        this.timestampCreator = service;
    }

    public String getC14nAlgorithm() {
        return this.c14nAlgorithm;
    }

    public ITimestampCreator getTimestampCreator() {
        return this.timestampCreator;
    }

    public boolean isEnforceTimestamp() {
        return this.enforceTimestamp;
    }

    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory factory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        if (this.getTimestampCreator() == null) {
            if (this.isEnforceTimestamp()) {
                throw new MarshalException("Signature timestamp required, but none available!");
            }
            return;
        }
        DigestAlgorithm hashAlgorithm = (DigestAlgorithm)context.get("de.intarsys.method.xml.hashAlgorithm");
        if (hashAlgorithm == null) {
            throw new IllegalArgumentException("'hashAlgorithm' is required");
        }
        Element elSignature = DOMTools.getElementLast((Element)((Element)((DOMSignContext)context).getParent()), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        Element elSignatureValue = DOMTools.getElementFirst((Element)elSignature, (String)"http://www.w3.org/2000/09/xmldsig#", (String)"SignatureValue");
        if (elSignatureValue == null) {
            return;
        }
        try {
            CanonicalizationMethod transform = factory.newCanonicalizationMethod(this.getC14nAlgorithm(), (C14NMethodParameterSpec)null);
            DOMSubTreeData data = new DOMSubTreeData((Node)elSignatureValue, false);
            Data transformed = transform.transform((Data)data, context);
            InputStream transformedStream = ((OctetStreamData)transformed).getOctetStream();
            IDigester digester = DigestTools.getDigester((Object)hashAlgorithm);
            digester.digestUpdate(transformedStream);
            IDigest digest = digester.digestFinal();
            PlainTimestampRequest timestampRequest = new PlainTimestampRequest(digest);
            ITimestampResponse timestampResponse = this.getTimestampCreator().createTimestamp((ITimestampRequest)timestampRequest);
            CanonicalizationMethodType canonicalization = new CanonicalizationMethodType();
            canonicalization.setAlgorithm(this.getC14nAlgorithm());
            XAdESTimeStampType timestamp = new XAdESTimeStampType();
            timestamp.setCanonicalizationMethod(canonicalization);
            EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
            encapsulated.setValue(timestampResponse.getTimestamp().getEncoded());
            encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
            timestamp.getEncapsulatedTimeStampOrXMLTimeStamp().add(encapsulated);
            JAXBElement jaxbTimestamp = XAdESBaseline.OF_1_3.createSignatureTimeStamp(timestamp);
            XAdESMarshaller.get().marshal(parentSupplier.get(), jaxbTimestamp);
        }
        catch (MarshalException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MarshalException(e);
        }
    }

    public void setC14nAlgorithm(String c14nAlgorithm) {
        this.c14nAlgorithm = c14nAlgorithm;
    }

    public void setEnforceTimestamp(boolean enforceTimestamp) {
        this.enforceTimestamp = enforceTimestamp;
    }

    public void setTimestampCreator(ITimestampCreator timestampCreator) {
        this.timestampCreator = timestampCreator;
    }
}

