/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.method.xml.attribute.encoder.SignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XAdESMarshaller;
import de.intarsys.tools.dom.DOMTools;
import java.util.Collection;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignerRoleV2Encoder
extends SignedPropertyEncoder {
    private Collection<IX509AttributeCertificate> attributeCertificates;

    public SignerRoleV2Encoder(Collection<IX509AttributeCertificate> attributeCertificates) {
        this.attributeCertificates = attributeCertificates;
    }

    protected Element createSignerRoleElement(XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        Element eSignerRoleV2 = DOMTools.createChild((Node)parentSupplier.get(), (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"SignerRoleV2");
        if (!this.getAttributeCertificates().isEmpty()) {
            Element eCertifiedRolesV2 = DOMTools.createChild((Node)eSignerRoleV2, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"CertifiedRolesV2");
            for (IX509AttributeCertificate attributeCertificate : this.getAttributeCertificates()) {
                Element eCertifiedRole = DOMTools.createChild((Node)eCertifiedRolesV2, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"CertifiedRole");
                Element eX509AttributeCertificate = DOMTools.createChild((Node)eCertifiedRole, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"X509AttributeCertificate");
                XAdESMarshaller.get().marshalEncapsulatedPKIDataType(context, eX509AttributeCertificate, (IX509Certificate)attributeCertificate);
            }
        }
        return eSignerRoleV2;
    }

    public Collection<IX509AttributeCertificate> getAttributeCertificates() {
        return this.attributeCertificates;
    }

    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory xmlSignatureFactory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        this.createSignerRoleElement(context, parentSupplier);
    }
}

