/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.method.xml.attribute.encoder.SignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.tools.date.TimeEnvironment;
import de.intarsys.tools.dom.DOMTools;
import java.time.Instant;
import java.util.Date;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SigningTimeEncoder
extends SignedPropertyEncoder {
    public static final String EL_SIGNING_TIME = "SigningTime";

    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory xmlSignatureFactory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        Instant time = TimeEnvironment.get().now();
        Long offset = (Long)context.get("de.intarsys.method.xml.signatureTimeOffset");
        if (offset != null) {
            time = time.plusMillis(offset);
        }
        String nowString = XMLDSigMarshaller.get().marshalIsoDateTime(Date.from(time));
        DOMTools.createChild((Node)parentSupplier.get(), (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)EL_SIGNING_TIME).setTextContent(nowString);
    }
}

