/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.attribute.encoder;

import de.intarsys.security.method.xml.attribute.encoder.UnsignedPropertyEncoder;
import de.intarsys.security.method.xml.common.XAdESMarshaller;
import de.intarsys.security.method.xml.spec.XAdESBaseline;
import de.intarsys.security.method.xml.validation.XMLValidationDataExtender;
import de.intarsys.security.ocsp.IOCSPResponse;
import de.intarsys.security.ocsp.common.OCSPTools;
import de.intarsys.security.validation.IExtendedValidationData;
import de.intarsys.tools.exception.ExceptionTools;
import jakarta.xml.bind.JAXBElement;
import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import org.etsi.uri._01903.v1_3.CRLValuesType;
import org.etsi.uri._01903.v1_3.CertificateValuesType;
import org.etsi.uri._01903.v1_3.EncapsulatedPKIDataType;
import org.etsi.uri._01903.v1_3.OCSPValuesType;
import org.etsi.uri._01903.v1_3.RevocationValuesType;
import org.etsi.uri._01903.v1_4.ValidationDataType;
import org.w3c.dom.Element;

public class TimeStampValidationDataEncoder
extends UnsignedPropertyEncoder {
    @Override
    public boolean isSignatureProperty() {
        return true;
    }

    @Override
    public void marshal(XMLSignatureFactory factory, XMLCryptoContext context, Supplier<Element> parentSupplier) throws MarshalException {
        IExtendedValidationData extendedValidationData = XMLValidationDataExtender.getExtendedValidationData(context);
        try {
            ValidationDataType value = new ValidationDataType();
            CertificateValuesType certificateValues = new CertificateValuesType();
            extendedValidationData.getCertificates().forEach(certificate -> {
                try {
                    byte[] encoded = certificate.getEncoded();
                    EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
                    encapsulated.setValue(encoded);
                    encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
                    certificateValues.getEncapsulatedX509CertificateOrOtherCertificate().add(encapsulated);
                }
                catch (CertificateEncodingException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, MarshalException.class);
                }
            });
            if (!certificateValues.getEncapsulatedX509CertificateOrOtherCertificate().isEmpty()) {
                value.setCertificateValues(certificateValues);
            }
            RevocationValuesType revocationValues = new RevocationValuesType();
            OCSPValuesType ocspValues = new OCSPValuesType();
            extendedValidationData.getOCSPResponses().forEach(ocsp -> {
                try {
                    byte[] encoded = OCSPTools.encodeAsn1OcspResponse((IOCSPResponse)ocsp);
                    EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
                    encapsulated.setValue(encoded);
                    encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
                    ocspValues.getEncapsulatedOCSPValue().add(encapsulated);
                }
                catch (IOException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, MarshalException.class);
                }
            });
            if (!ocspValues.getEncapsulatedOCSPValue().isEmpty()) {
                revocationValues.setOCSPValues(ocspValues);
                value.setRevocationValues(revocationValues);
            }
            CRLValuesType crlValues = new CRLValuesType();
            extendedValidationData.getCRLs().forEach(crl -> {
                try {
                    byte[] encoded = crl.getEncoded();
                    EncapsulatedPKIDataType encapsulated = new EncapsulatedPKIDataType();
                    encapsulated.setValue(encoded);
                    encapsulated.setEncoding("http://uri.etsi.org/01903/v1.2.2#DER");
                    crlValues.getEncapsulatedCRLValue().add(encapsulated);
                }
                catch (CRLException e) {
                    throw ExceptionTools.wrapTyped((Throwable)e, MarshalException.class);
                }
            });
            if (!crlValues.getEncapsulatedCRLValue().isEmpty()) {
                revocationValues.setCRLValues(crlValues);
                value.setRevocationValues(revocationValues);
            }
            if (value.getCertificateValues() == null && value.getRevocationValues() == null) {
                return;
            }
            JAXBElement jaxb = XAdESBaseline.OF_1_4.createTimeStampValidationData(value);
            XAdESMarshaller.get().marshal(parentSupplier.get(), jaxb);
        }
        catch (Exception e) {
            throw (MarshalException)ExceptionTools.unwrapTypedFromChain((Throwable)e, MarshalException.class);
        }
    }
}

