/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.common;

import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.xml.common.XAdESNamespacePrefixMapper;
import de.intarsys.security.method.xml.common.XMLDSigMarshaller;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.digest.IDigester;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.encoding.Base64;
import jakarta.xml.bind.JAXBContext;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateEncodingException;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import org.etsi.uri._01903.v1_4.ObjectFactory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@SingletonClass
public class XAdESMarshaller {
    private static final String ATTR_QUALIFIER_VALUE_OID_AS_URN = "OIDAsURN";
    private static final String ATTR_QUALIFIER = "Qualifier";
    private static final String EL_IDENTIFIER = "Identifier";
    private static final String EL_X509_SERIAL_NUMBER = "X509SerialNumber";
    private static final String EL_X509_ISSUER_NAME = "X509IssuerName";
    private static final String EL_ISSUER_SERIAL = "IssuerSerial";
    private static final String PREFIX_MAPPER = "org.glassfish.jaxb.namespacePrefixMapper";
    private static final XAdESMarshaller INSTANCE = new XAdESMarshaller();
    private JAXBContext jaxbContext;
    private MarshalException jaxbContextException;

    public static XAdESMarshaller get() {
        return INSTANCE;
    }

    protected XAdESMarshaller() {
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{org.w3._2000._09.xmldsig.ObjectFactory.class, org.etsi.uri._01903.v1_3.ObjectFactory.class, ObjectFactory.class});
        }
        catch (JAXBException e) {
            this.jaxbContextException = new MarshalException(e);
        }
    }

    protected JAXBContext getJaxbContext() throws MarshalException {
        if (this.jaxbContextException != null) {
            throw this.jaxbContextException;
        }
        return this.jaxbContext;
    }

    public void marshal(Node node, Object object) throws MarshalException {
        try {
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty(PREFIX_MAPPER, (Object)new XAdESNamespacePrefixMapper());
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(object, node);
        }
        catch (JAXBException e) {
            throw new MarshalException(e);
        }
    }

    public void marshalCert(XMLCryptoContext context, Node parent, IX509PublicKeyCertificate certificate) throws MarshalException {
        Element cert = DOMTools.createChild((Node)parent, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"Cert");
        try {
            IDigester digester = DigestTools.createDigester((String)"SHA-256");
            IDigest digest = digester.digest(certificate.getEncoded());
            Element certDigest = DOMTools.createChild((Node)cert, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"CertDigest");
            XMLDSigMarshaller.get().marshalDigestAlgAndValue(context, certDigest, digest);
        }
        catch (GeneralSecurityException e) {
            throw new MarshalException(e);
        }
        this.marshalIssuerSerial(context, cert, certificate);
    }

    public void marshalCertV2(XMLCryptoContext context, Node parent, IX509PublicKeyCertificate certificate) throws MarshalException {
        Element cert = DOMTools.createChild((Node)parent, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"Cert");
        try {
            IDigester digester = DigestTools.createDigester((String)"SHA-256");
            IDigest digest = digester.digest(certificate.getEncoded());
            Element certDigest = DOMTools.createChild((Node)cert, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"CertDigest");
            XMLDSigMarshaller.get().marshalDigestAlgAndValue(context, certDigest, digest);
        }
        catch (GeneralSecurityException e) {
            throw new MarshalException(e);
        }
    }

    public void marshalEncapsulatedPKIDataType(XMLCryptoContext context, Element element, IX509Certificate certificate) throws MarshalException {
        try {
            element.setAttribute("Encoding", "http://uri.etsi.org/01903/v1.2.2#DER");
            element.setTextContent(new String(Base64.encode((byte[])certificate.getEncoded())));
        }
        catch (CertificateEncodingException e) {
            throw new MarshalException(e);
        }
    }

    public void marshalIssuerSerial(XMLCryptoContext context, Node parent, IX509PublicKeyCertificate certificate) {
        Element issuerSerial = DOMTools.createChild((Node)parent, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)EL_ISSUER_SERIAL);
        DOMTools.createChild((Node)issuerSerial, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_X509_ISSUER_NAME).setTextContent(String.valueOf(certificate.getIssuerX500Principal()));
        DOMTools.createChild((Node)issuerSerial, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_X509_SERIAL_NUMBER).setTextContent(String.valueOf(certificate.getSerialNumber()));
    }

    public void marshalObjectIdentifierType(XMLCryptoContext context, Node parent, String oid) throws DOMException {
        Element eIdentifier = DOMTools.createChild((Node)parent, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)EL_IDENTIFIER);
        eIdentifier.setAttribute(ATTR_QUALIFIER, ATTR_QUALIFIER_VALUE_OID_AS_URN);
        eIdentifier.setTextContent("urn:oid:" + oid);
    }
}

