/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.common;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.certificate.IX509AttributeCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.signature.policy.INoticeReference;
import de.intarsys.security.signature.policy.IQualifier;
import de.intarsys.security.signature.policy.NoticeReference;
import de.intarsys.security.signature.policy.common.ISPURIQualifier;
import de.intarsys.security.signature.policy.common.ISPUserNoticeQualifier;
import de.intarsys.security.signature.policy.common.SPURIQualifier;
import de.intarsys.security.signature.policy.common.SPUserNoticeQualifier;
import de.intarsys.tools.component.SingletonClass;
import de.intarsys.tools.digest.DigestTools;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.security.cert.CertificateException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLCryptoContext;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@SingletonClass
public class XMLDSigMarshaller {
    private static final String EL_SP_USER_NOTICE = "SPUserNotice";
    private static final String EL_EXPLICIT_TEXT = "ExplicitText";
    private static final String EL_NOTICE_NUMBERS = "NoticeNumbers";
    private static final String EL_ORGANIZATION = "Organization";
    private static final String EL_NOTICE_REF = "NoticeRef";
    private static final String EL_SPURI = "SPURI";
    private static final String EL_DIGEST_METHOD = "DigestMethod";
    private static final String EL_DIGEST_VALUE = "DigestValue";
    private static final XMLDSigMarshaller ACTIVE = new XMLDSigMarshaller();
    public static final DateTimeFormatter ISO_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().appendValue(ChronoField.YEAR, 4, 10, SignStyle.EXCEEDS_PAD).appendLiteral('-').appendValue(ChronoField.MONTH_OF_YEAR, 2).appendLiteral('-').appendValue(ChronoField.DAY_OF_MONTH, 2).appendLiteral('T').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalStart().appendOffsetId().toFormatter();

    public static XMLDSigMarshaller get() {
        return ACTIVE;
    }

    private XMLDSigMarshaller() {
    }

    public IDigest decodeDigestAlgAndValue(Element eDigestAlgAndValueType) throws IOException {
        String base64Digest;
        String digestAlgorithmName;
        NodeList digestMethodNodes = eDigestAlgAndValueType.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", EL_DIGEST_METHOD);
        if (digestMethodNodes.getLength() > 0) {
            digestAlgorithmName = ((Element)digestMethodNodes.item(0)).getAttribute("Algorithm");
            if (StringTools.isEmpty((String)digestAlgorithmName)) {
                throw new IOException("attribute 'Algorithm' is required");
            }
        } else {
            throw new IOException("element 'DigestMethod' is required");
        }
        NodeList digestValueNodes = eDigestAlgAndValueType.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", EL_DIGEST_VALUE);
        if (digestValueNodes.getLength() > 0) {
            base64Digest = digestValueNodes.item(0).getTextContent();
            if (StringTools.isEmpty((String)base64Digest)) {
                throw new IOException("element 'DigestValue' must have a base64 encoded content");
            }
        } else {
            throw new IOException("element 'DigestValue' is required");
        }
        byte[] digestValue = Base64.decode((String)base64Digest);
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)digestAlgorithmName);
        if (digestAlgorithm == null) {
            throw new IOException("Unknown digest algorithm: " + digestAlgorithmName);
        }
        return DigestTools.createDigest((String)digestAlgorithm.getName(), (byte[])digestValue);
    }

    public IX509AttributeCertificate decodeEncapsulatedPKIDataTypeAttributeCertificate(Element element) throws CertificateException, DOMException {
        try {
            byte[] data = Base64.decode((String)element.getTextContent());
            return X509CertificateFactory.get().createAttributeCertificate(data);
        }
        catch (IOException e) {
            throw new CertificateException("certificate data invalid", e);
        }
    }

    protected int[] decodeIntegerList(Element eIntegerListType) {
        List elements = DOMTools.getElements((Element)eIntegerListType, (String)"int");
        int[] result = new int[elements.size()];
        for (int i = 0; i < elements.size(); ++i) {
            result[i] = Integer.parseInt(((Element)elements.get(i)).getTextContent());
        }
        return result;
    }

    public String decodeObjectIdentifier(Element eObjectIdentifierType) throws IOException {
        Element eIdentifier = DOMTools.getElementFirst((Element)eObjectIdentifierType, (String)"Identifier");
        String idQualifier = eIdentifier.getAttribute("Qualifier");
        if ("OIDAsURN".equals(idQualifier)) {
            String oid = eIdentifier.getTextContent();
            oid = oid.substring(8);
            return oid;
        }
        throw new IOException("ID qualifier type " + idQualifier + " not supported!");
    }

    public IQualifier decodeQualifier(Element eSigPolicyQualifier) throws IOException {
        Element eQualifier = DOMTools.getElementFirst((Element)eSigPolicyQualifier);
        if (EL_SPURI.equals(eQualifier.getLocalName())) {
            return this.decodeQualifierSPURI(eQualifier);
        }
        if (EL_SP_USER_NOTICE.equals(eQualifier.getLocalName())) {
            return this.decodeQualifierSPUserNotice(eQualifier);
        }
        throw new IOException("Unsupported qualifier element: " + eQualifier.getLocalName());
    }

    protected IQualifier decodeQualifierSPURI(Element eQualifier) {
        String uri = eQualifier.getTextContent();
        return new SPURIQualifier(uri);
    }

    protected IQualifier decodeQualifierSPUserNotice(Element eQualifier) {
        Element eExplicitText;
        NoticeReference noticeReference = null;
        String explicitText = null;
        Element eNoticeRef = DOMTools.getElementFirst((Element)eQualifier, (String)EL_NOTICE_REF);
        if (eNoticeRef != null) {
            Element eOrganization = DOMTools.getElementFirst((Element)eNoticeRef, (String)EL_ORGANIZATION);
            int[] noticeNumbers = this.decodeIntegerList(DOMTools.getElementFirst((Element)eNoticeRef, (String)EL_NOTICE_NUMBERS));
            noticeReference = new NoticeReference(eOrganization.getTextContent(), noticeNumbers);
        }
        if ((eExplicitText = DOMTools.getElementFirst((Element)eQualifier, (String)EL_EXPLICIT_TEXT)) != null) {
            explicitText = eExplicitText.getTextContent();
        }
        return new SPUserNoticeQualifier(noticeReference, explicitText);
    }

    public void marshalDigestAlgAndValue(XMLCryptoContext context, Element eDigestAlgAndValueType, IDigest digest) throws DOMException {
        Element eDigestMethod = DOMTools.createChild((Node)eDigestAlgAndValueType, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_DIGEST_METHOD);
        eDigestAlgAndValueType.appendChild(eDigestMethod);
        String digestMethodName = XMLDSigTools.lookupDigestAlgorithm(digest.getAlgorithmName()).getName();
        eDigestMethod.setAttribute("Algorithm", digestMethodName);
        Element eDigestValue = DOMTools.createChild((Node)eDigestAlgAndValueType, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_DIGEST_VALUE);
        eDigestAlgAndValueType.appendChild(eDigestValue);
        String digestValue = new String(Base64.encode((byte[])digest.getBytes()));
        eDigestValue.setTextContent(digestValue);
    }

    public String marshalIsoDateTime(Date date) {
        return ISO_DATE_TIME.format(Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()));
    }

    public String marshalIsoDateTime(ZonedDateTime dateTime) {
        return ISO_DATE_TIME.format(dateTime);
    }

    public void marshalQualifier(XMLCryptoContext context, Element eQualifierType, IQualifier qualifier) throws DOMException, MarshalException {
        Object encoded = null;
        if (qualifier instanceof ISPURIQualifier) {
            this.marshalQualifierSPURI(context, eQualifierType, (ISPURIQualifier)qualifier);
        } else if (qualifier instanceof ISPUserNoticeQualifier) {
            this.marshalQualifierSPUserNotice(context, eQualifierType, (ISPUserNoticeQualifier)qualifier);
        } else {
            throw new MarshalException("ID qualifier type " + qualifier.getOID() + " not supported!");
        }
    }

    protected Element marshalQualifierSPURI(XMLCryptoContext context, Element eQualifierType, ISPURIQualifier qualifier) throws DOMException, MarshalException {
        Element eSPURI = DOMTools.createChild((Node)eQualifierType, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_SPURI);
        eSPURI.setTextContent(qualifier.getURI());
        return eSPURI;
    }

    protected Element marshalQualifierSPUserNotice(XMLCryptoContext context, Element eQualifierType, ISPUserNoticeQualifier qualifier) throws DOMException, MarshalException {
        Element eSPUserNotice = DOMTools.createChild((Node)eQualifierType, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_SP_USER_NOTICE);
        if (qualifier.getNoticeReference() != null) {
            INoticeReference noticeReference = qualifier.getNoticeReference();
            Element eNoticeRef = DOMTools.createChild((Node)eSPUserNotice, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_NOTICE_REF);
            Element eOrganization = DOMTools.createChild((Node)eNoticeRef, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_ORGANIZATION);
            eOrganization.setTextContent(noticeReference.getOrganization());
            Element eNoticeNumbers = DOMTools.createChild((Node)eNoticeRef, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_NOTICE_NUMBERS);
            for (int i = 0; i < noticeReference.getNoticeNumbers().length; ++i) {
                int number = noticeReference.getNoticeNumbers()[i];
                Element eInt = DOMTools.createChild((Node)eNoticeNumbers, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)"int");
                eInt.setTextContent(String.valueOf(number));
            }
        }
        if (qualifier.getExplicitText() != null) {
            Element eExplicitText = DOMTools.createChild((Node)eSPUserNotice, (String)"http://www.w3.org/2000/09/xmldsig#", (String)context.getNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", "ds"), (String)EL_EXPLICIT_TEXT);
            eExplicitText.setTextContent(qualifier.getExplicitText());
        }
        return eSPUserNotice;
    }
}

