/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.common;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public final class XMLDSigTools {
    private static final Map<String, DigestAlgorithm> DIGEST_ALGORITHMS = new HashMap<String, DigestAlgorithm>();
    private static final Map<String, SignatureAlgorithm> SIGNATURE_ALGORITHMS = new HashMap<String, SignatureAlgorithm>();

    public static List<DigestAlgorithm> getDigestAlgorithms() {
        return new ArrayList<DigestAlgorithm>(DIGEST_ALGORITHMS.values());
    }

    public static List<SignatureAlgorithm> getSignatureAlgorithms() {
        return new ArrayList<SignatureAlgorithm>(SIGNATURE_ALGORITHMS.values());
    }

    public static DigestAlgorithm lookupDigestAlgorithm(String id) {
        DigestAlgorithm algorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)id);
        return algorithm == null ? null : DIGEST_ALGORITHMS.get(algorithm.getOid());
    }

    public static SignatureAlgorithm lookupSignatureAlgorithmByXMLName(String id) {
        return SIGNATURE_ALGORITHMS.get(id);
    }

    public static void register(DigestAlgorithm algorithm) {
        DIGEST_ALGORITHMS.put(algorithm.getOid(), algorithm);
    }

    public static void register(SignatureAlgorithm algorithm) {
        SIGNATURE_ALGORITHMS.put(algorithm.getName(), algorithm);
    }

    public static SignatureAlgorithm searchSignatureAlgorithm(Predicate<SignatureAlgorithm> ... predicates) {
        for (SignatureAlgorithm algorithm : XMLDSigTools.getSignatureAlgorithms()) {
            if (!XMLDSigTools.searchSignatureAlgorithmTest(algorithm, predicates)) continue;
            return algorithm;
        }
        return null;
    }

    protected static boolean searchSignatureAlgorithmTest(SignatureAlgorithm algorithm, Predicate<SignatureAlgorithm> ... predicates) {
        for (Predicate<SignatureAlgorithm> predicate : predicates) {
            if (predicate.test(algorithm)) continue;
            return false;
        }
        return true;
    }

    private XMLDSigTools() {
    }

    static {
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1", DigestAlgorithm.ALG_SHA1));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha224", DigestAlgorithm.ALG_SHA224));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256", DigestAlgorithm.ALG_SHA256));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2001/04/xmldsig-more#sha384", DigestAlgorithm.ALG_SHA384));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha512", DigestAlgorithm.ALG_SHA512));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2001/04/xmlenc#ripemd160", DigestAlgorithm.ALG_RIPEMD160));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-224", DigestAlgorithm.ALG_SHA3_224));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-256", DigestAlgorithm.ALG_SHA3_256));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-384", DigestAlgorithm.ALG_SHA3_384));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha3-512", DigestAlgorithm.ALG_SHA3_512));
        XMLDSigTools.register(new DigestAlgorithm("http://www.w3.org/2007/05/xmldsig-more#whirlpool", DigestAlgorithm.ALG_WHIRLPOOL));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1", SignatureAlgorithm.ALG_SHA1WithRSAEncryption));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha224", SignatureAlgorithm.ALG_SHA224WithRSAEncryption));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256", SignatureAlgorithm.ALG_SHA256WithRSAEncryption));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384", SignatureAlgorithm.ALG_SHA384WithRSAEncryption));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512", SignatureAlgorithm.ALG_SHA512WithRSAEncryption));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160", SignatureAlgorithm.ALG_RSASignatureWithripemd160));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha1-rsa-MGF1", DigestAlgorithm.ALG_SHA1, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha224-rsa-MGF1", DigestAlgorithm.ALG_SHA224, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha256-rsa-MGF1", DigestAlgorithm.ALG_SHA256, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha384-rsa-MGF1", DigestAlgorithm.ALG_SHA384, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#sha512-rsa-MGF1", DigestAlgorithm.ALG_SHA512, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#ripemd128-rsa-MGF1", DigestAlgorithm.ALG_RIPEMD128, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2007/05/xmldsig-more#ripemd160-rsa-MGF1", DigestAlgorithm.ALG_RIPEMD160, SignatureAlgorithm.ALG_RSASSA_PSS));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1", SignatureAlgorithm.ALG_ECDSAWithSHA1));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha224", SignatureAlgorithm.ALG_ECDSAWithSHA224));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256", SignatureAlgorithm.ALG_ECDSAWithSHA256));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384", SignatureAlgorithm.ALG_ECDSAWithSHA384));
        XMLDSigTools.register(new SignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512", SignatureAlgorithm.ALG_ECDSAWithSHA512));
    }
}

