/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.QualifyingProperties;
import de.intarsys.security.signature.attribute.IAttribute;
import de.intarsys.security.signature.attribute.IAttributeMap;
import java.io.IOException;
import java.util.Set;

public abstract class AttributesFilter
implements IAttributeMap {
    private final QualifyingProperties qualifyingProperties;
    private final String acceptedNode;

    protected AttributesFilter(QualifyingProperties qualifyingProperties, String acceptedNode) {
        this.qualifyingProperties = qualifyingProperties;
        this.acceptedNode = acceptedNode;
    }

    public boolean contains(String oid) {
        return this.qualifyingProperties.contains(oid);
    }

    public IAttribute get(String oid) throws IOException {
        String path = this.qualifyingProperties.mapTypeToNodePath(oid);
        if (path != null && path.startsWith(this.acceptedNode)) {
            return this.qualifyingProperties.get(oid);
        }
        return null;
    }

    protected QualifyingProperties getQualifyingProperties() {
        return this.qualifyingProperties;
    }

    public static class UnsignedProperties
    extends AttributesFilter {
        public UnsignedProperties(QualifyingProperties qualifyingProperties) {
            super(qualifyingProperties, "UnsignedProperties");
        }

        public Set<String> getOIDs() {
            return this.getQualifyingProperties().getUnsignedTypes();
        }
    }

    public static class SignedProperties
    extends AttributesFilter {
        public SignedProperties(QualifyingProperties qualifyingProperties) {
            super(qualifyingProperties, "SignedProperties");
        }

        public Set<String> getOIDs() {
            return this.getQualifyingProperties().getSignedTypes();
        }
    }
}

