/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.AbstractSignatureTarget;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import de.intarsys.tools.encoding.Base64;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.stream.StreamTools;
import de.intarsys.tools.string.StringTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.util.Collections;
import javax.xml.crypto.Data;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.apache.jcp.xml.dsig.internal.dom.ApacheOctetStreamData;
import org.apache.jcp.xml.dsig.internal.dom.StupidCopyOfUtils;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.w3c.dom.Text;

public class BinaryDocumentTarget
extends AbstractSignatureTarget
implements URIDereferencer {
    private ILocator locator;
    private boolean embed;
    private String mimeType;
    private String uriString;

    public BinaryDocumentTarget(ILocator locator) {
        this.locator = locator;
        this.embed = false;
    }

    protected Reference createEmbeddedReference(XMLSignatureContainerBuilder xmlSigner) throws GeneralSecurityException {
        String embededData = null;
        try {
            byte[] bytes = StreamTools.getBytes((InputStream)this.getLocator().getInputStream());
            embededData = new String(Base64.encode((byte[])bytes));
        }
        catch (IOException e) {
            throw new GeneralSecurityException(e.getLocalizedMessage(), e);
        }
        Text text = xmlSigner.getDocument().createTextNode(embededData);
        DOMStructure content = new DOMStructure(text);
        String id = xmlSigner.getNextUniqueId();
        XMLObject xmlObject = xmlSigner.getSignatureFactory().newXMLObject(Collections.singletonList(content), id, this.mimeType, "http://www.w3.org/2000/09/xmldsig#base64");
        xmlSigner.addXMLObject(xmlObject);
        this.uriString = "#" + id;
        return xmlSigner.getSignatureFactory().newReference(this.uriString, this.getDigestMethod(xmlSigner), null, "http://www.w3.org/2000/09/xmldsig#Object", null);
    }

    protected Reference createExternalReference(XMLSignatureContainerBuilder xmlSigner) throws GeneralSecurityException {
        try {
            this.uriString = this.getLocator().getName();
            this.uriString = URLEncoder.encode(this.uriString, "UTF-8");
            return xmlSigner.getSignatureFactory().newReference(this.uriString, this.getDigestMethod(xmlSigner));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("required encoding");
        }
    }

    @Override
    public Reference createReference(XMLSignatureContainerBuilder xmlSigner, DOMSignContext context) throws GeneralSecurityException {
        if (this.isEmbed()) {
            return this.createEmbeddedReference(xmlSigner);
        }
        return this.createExternalReference(xmlSigner);
    }

    @Override
    public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
        if (this.isEmbed() || StringTools.isEmpty((String)this.getUriString()) || !this.getUriString().equals(uriReference.getURI())) {
            return null;
        }
        try {
            XMLSignatureInput input = new XMLSignatureInput(this.getLocator().getInputStream());
            input.setSecureValidation(StupidCopyOfUtils.secureValidation(context));
            input.setSourceURI(uriReference.getURI());
            ApacheOctetStreamData data = new ApacheOctetStreamData(input);
            return data;
        }
        catch (Exception e) {
            throw new URIReferenceException(e);
        }
    }

    public ILocator getLocator() {
        return this.locator;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getUriString() {
        return this.uriString;
    }

    public boolean isEmbed() {
        return this.embed;
    }

    public void setEmbed(boolean embed) {
        this.embed = embed;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

