/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.digest.DigestTools;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.method.common.signature.SignatureOptions;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.XMLSignerTools;
import de.intarsys.tools.factory.CommonInstantiatingFactory;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;

public abstract class CommonXMLSignatureContainerBuilderFactory
extends CommonInstantiatingFactory<IXMLSignatureContainerBuilder> {
    protected CommonXMLSignatureContainerBuilderFactory() {
    }

    protected IXMLSignatureContainerBuilder basicCreateInstance(IArgs args) throws ObjectCreationException {
        ISigner digestSigner = AdESSignerTools.getSigner((IArgs)args);
        this.prepareDigestSigner(digestSigner, args);
        XMLSignatureContainerBuilder signer = new XMLSignatureContainerBuilder(digestSigner);
        this.prepareXMLSigner(signer, args);
        return signer;
    }

    public Class<IXMLSignatureContainerBuilder> getResultType() {
        return IXMLSignatureContainerBuilder.class;
    }

    protected void prepareDigestSigner(ISigner signer, IArgs args) throws ObjectCreationException {
        SignatureOptions signatureOptions = AdESSignerTools.getSignatureOptions((IArgs)args);
        signer.setSignatureOptions(signatureOptions);
    }

    protected void prepareXMLSigner(XMLSignatureContainerBuilder xmlSigner, IArgs args) throws ObjectCreationException {
        xmlSigner.setBaseUri(XMLSignerTools.getBaseUri(args));
        xmlSigner.setNamespaces(XMLSignerTools.getNamespaces(args));
        xmlSigner.setParentNodeLookup(XMLSignerTools.getParentNodeLookup(args));
        xmlSigner.setParentNodeCreate(XMLSignerTools.getParentNodeCreate(args));
        xmlSigner.setSignatureElementId(XMLSignerTools.getSignatureElementId(args));
        xmlSigner.setHashAlgorithm(DigestTools.getHashAlgorithm((IArgs)args, (String)"SHA-256"));
    }
}

