/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.AbstractSignatureTarget;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import java.security.GeneralSecurityException;
import java.util.Collections;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.w3c.dom.Element;

public class EnvelopingSignatureTarget
extends AbstractSignatureTarget {
    private Element element;
    private String mimeType;

    public EnvelopingSignatureTarget(Element element, String mimeType) {
        this.element = element;
        this.mimeType = mimeType;
    }

    @Override
    public Reference createReference(XMLSignatureContainerBuilder xmlSigner, DOMSignContext context) throws GeneralSecurityException {
        DOMStructure content = new DOMStructure(this.element);
        String id = xmlSigner.getNextUniqueId();
        XMLObject xmlObject = xmlSigner.getSignatureFactory().newXMLObject(Collections.singletonList(content), id, this.mimeType, null);
        xmlSigner.addXMLObject(xmlObject);
        DigestMethod digestMethod = this.getDigestMethod(xmlSigner);
        return xmlSigner.getSignatureFactory().newReference("#" + id, digestMethod);
    }
}

