/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.attribute.decoder.WellKnownAttributes;
import de.intarsys.security.signature.attribute.IAttribute;
import de.intarsys.security.signature.attribute.IAttributeDecoder;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.tools.dom.DOMTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class QualifyingProperties
implements IAttributeMap {
    public static final String SIGNED_DATA_OBJECT_PROPERTIES = "SignedDataObjectProperties";
    public static final String UNSIGNED_DATA_OBJECT_PROPERTIES = "UnsignedDataObjectProperties";
    public static final String UNSIGNED_PROPERTIES = "UnsignedProperties";
    public static final String PATH_SEPARATOR = "/";
    public static final String SIGNED_PROPERTIES = "SignedProperties";
    public static final String SIGNED_SIGNATURE_PROPERTIES = "SignedSignatureProperties";
    public static final String UNSIGNED_SIGNATURE_PROPERTIES = "UnsignedSignatureProperties";
    private final Element qualifyingProperties;

    public QualifyingProperties(Element qualifyingProperties) {
        this.qualifyingProperties = qualifyingProperties;
    }

    public boolean contains(String type) {
        String nodePath = this.mapTypeToNodePath(type);
        return !this.lookupQualifyingPropertyElements(nodePath).isEmpty();
    }

    protected IAttribute decodeAttribute(String type, List<Element> attributeElements) throws IOException {
        IAttributeDecoder decoder = WellKnownAttributes.get().lookupDecoder(type);
        if (decoder != null) {
            return decoder.decodeAttribute(attributeElements);
        }
        return null;
    }

    public IAttribute get(String type) throws IOException {
        String nodePath = this.mapTypeToNodePath(type);
        List<Element> attributeElements = this.lookupQualifyingPropertyElements(nodePath);
        if (attributeElements.isEmpty()) {
            return null;
        }
        return this.decodeAttribute(type, attributeElements);
    }

    protected Element getElementByTagNameNS(Element parent, String namespaceURI, String localName) {
        NodeList nodeList = parent.getElementsByTagNameNS(namespaceURI, localName);
        if (nodeList.getLength() == 0) {
            return null;
        }
        return (Element)nodeList.item(0);
    }

    public Set<String> getOIDs() {
        HashSet<String> types = new HashSet<String>();
        types.addAll(this.getSignedTypes());
        types.addAll(this.getUnsignedTypes());
        return types;
    }

    protected Set<String> getSignedTypes() {
        HashSet<String> types = new HashSet<String>();
        Element signedProperties = this.getElementByTagNameNS(this.qualifyingProperties, "http://uri.etsi.org/01903/v1.3.2#", SIGNED_PROPERTIES);
        if (signedProperties != null) {
            Element signedDataObjectProperties;
            Element signedSignatureProperties = this.getElementByTagNameNS(signedProperties, "http://uri.etsi.org/01903/v1.3.2#", SIGNED_SIGNATURE_PROPERTIES);
            if (signedSignatureProperties != null) {
                this.scanPropertyNodeList(signedSignatureProperties.getChildNodes(), this.join(SIGNED_PROPERTIES, SIGNED_SIGNATURE_PROPERTIES), types);
            }
            if ((signedDataObjectProperties = this.getElementByTagNameNS(signedProperties, "http://uri.etsi.org/01903/v1.3.2#", SIGNED_DATA_OBJECT_PROPERTIES)) != null) {
                this.scanPropertyNodeList(signedDataObjectProperties.getChildNodes(), this.join(SIGNED_PROPERTIES, SIGNED_DATA_OBJECT_PROPERTIES), types);
            }
        }
        return types;
    }

    protected Set<String> getUnsignedTypes() {
        HashSet<String> types = new HashSet<String>();
        Element unsignedProperties = this.getElementByTagNameNS(this.qualifyingProperties, "http://uri.etsi.org/01903/v1.3.2#", UNSIGNED_PROPERTIES);
        if (unsignedProperties != null) {
            Element unsignedDataObjectProperties;
            Element unsignedSignatureProperties = this.getElementByTagNameNS(unsignedProperties, "http://uri.etsi.org/01903/v1.3.2#", UNSIGNED_SIGNATURE_PROPERTIES);
            if (unsignedSignatureProperties != null) {
                this.scanPropertyNodeList(unsignedSignatureProperties.getChildNodes(), this.join(UNSIGNED_PROPERTIES, UNSIGNED_SIGNATURE_PROPERTIES), types);
            }
            if ((unsignedDataObjectProperties = this.getElementByTagNameNS(unsignedProperties, "http://uri.etsi.org/01903/v1.3.2#", UNSIGNED_DATA_OBJECT_PROPERTIES)) != null) {
                this.scanPropertyNodeList(unsignedDataObjectProperties.getChildNodes(), this.join(UNSIGNED_PROPERTIES, UNSIGNED_DATA_OBJECT_PROPERTIES), types);
            }
        }
        return types;
    }

    private String join(String parent, String child) {
        return parent + PATH_SEPARATOR + child;
    }

    private Element lookupElement(String nodePath) {
        Element current = this.qualifyingProperties;
        for (String path : nodePath.split(PATH_SEPARATOR)) {
            NodeList subElementNodes = current.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", path);
            if (subElementNodes.getLength() <= 0) {
                return null;
            }
            current = (Element)subElementNodes.item(0);
        }
        return current;
    }

    protected List<Element> lookupQualifyingPropertyElements(String nodePath) {
        Element current = this.qualifyingProperties;
        String[] pathElements = nodePath.split(PATH_SEPARATOR);
        for (int i = 0; i < pathElements.length - 1; ++i) {
            if ((current = DOMTools.getElementFirst((Element)current, (String)pathElements[i])) != null) continue;
            return Collections.emptyList();
        }
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList subElementNodes = current.getElementsByTagNameNS("http://uri.etsi.org/01903/v1.3.2#", pathElements[pathElements.length - 1]);
        for (int i = 0; i < subElementNodes.getLength(); ++i) {
            result.add((Element)subElementNodes.item(i));
        }
        return result;
    }

    private String mapNodePathToType(String nodePath) {
        return WellKnownAttributes.get().mapNodePath2OID(nodePath);
    }

    public String mapTypeToNodePath(String type) {
        return WellKnownAttributes.get().mapOID2NodePath(type);
    }

    private void scanPropertyNodeList(NodeList nodeList, String pathPrefix, Set<String> types) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String elementName = nodeList.item(i).getLocalName();
            types.add(this.mapNodePathToType(this.join(pathPrefix, elementName)));
        }
    }
}

