/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.Base64Transformation;
import de.intarsys.security.method.xml.signature.CanonicalXMLTransformation;
import de.intarsys.security.method.xml.signature.CanonicalXMLWithCommentsTransformation;
import de.intarsys.security.method.xml.signature.EnvelopedSignatureTransformation;
import de.intarsys.security.method.xml.signature.ExclusiveCanonicalXMLTransformation;
import de.intarsys.security.method.xml.signature.ExclusiveCanonicalXMLWithCommentsTransformation;
import de.intarsys.security.method.xml.signature.ITransformation;
import de.intarsys.security.method.xml.signature.Transformation;
import de.intarsys.security.method.xml.signature.XPath2Transformation;
import de.intarsys.security.method.xml.signature.XPathTransformation;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;

public class TransformationFactory {
    private Map<String, Class<? extends Transformation>> transformations = new HashMap<String, Class<? extends Transformation>>();

    public TransformationFactory() {
        this.transformations.put("http://www.w3.org/2000/09/xmldsig#base64", Base64Transformation.class);
        this.transformations.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", CanonicalXMLTransformation.class);
        this.transformations.put("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", CanonicalXMLWithCommentsTransformation.class);
        this.transformations.put("http://www.w3.org/2000/09/xmldsig#enveloped-signature", EnvelopedSignatureTransformation.class);
        this.transformations.put("http://www.w3.org/2001/10/xml-exc-c14n#", ExclusiveCanonicalXMLTransformation.class);
        this.transformations.put("http://www.w3.org/2001/10/xml-exc-c14n#WithComments", ExclusiveCanonicalXMLWithCommentsTransformation.class);
        this.transformations.put("http://www.w3.org/TR/1999/REC-xpath-19991116", XPathTransformation.class);
        this.transformations.put("http://www.w3.org/2002/06/xmldsig-filter2", XPath2Transformation.class);
    }

    public ITransformation createTransformation(String algorithm, String filter, String expression) throws NoSuchAlgorithmException {
        Transformation transform;
        Class<? extends Transformation> clazz = this.transformations.get(algorithm);
        if (clazz == null) {
            throw new NoSuchAlgorithmException("Unknown algorithm:" + algorithm);
        }
        try {
            transform = clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        transform.setFilter(filter);
        transform.setExpression(expression);
        return transform;
    }
}

