/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.certificate.X509CertificateFactory;
import java.security.Key;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class X509DataKeySelector
extends KeySelector {
    public static final String NS_WSSE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd";
    public static final String NS_WSU = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd";
    public static final String WSSE_VALUE_TYPE_X509 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public static final String WSSE_ENCODING_TYPE_BINARY = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";

    protected IX509PublicKeyCertificate lookupCertificateByBinarySecurityTokenURI(String uri, Element baseElement) throws KeySelectorException {
        if (!uri.startsWith("#")) {
            return null;
        }
        String id = uri.substring(1);
        Element securityElement = (Element)baseElement.getParentNode().getParentNode().getParentNode();
        NodeList binarySecurityTokenElements = securityElement.getElementsByTagNameNS(NS_WSSE, "BinarySecurityToken");
        for (int i = 0; i < binarySecurityTokenElements.getLength(); ++i) {
            Element binarySecurityTokenElement = (Element)binarySecurityTokenElements.item(i);
            if (!id.equals(binarySecurityTokenElement.getAttributeNS(NS_WSU, "Id"))) continue;
            String encodingType = binarySecurityTokenElement.getAttribute("EncodingType");
            String valueType = binarySecurityTokenElement.getAttribute("ValueType");
            if (!WSSE_ENCODING_TYPE_BINARY.equals(encodingType) || !WSSE_VALUE_TYPE_X509.equals(valueType)) continue;
            String certificateValue = binarySecurityTokenElement.getTextContent();
            try {
                IX509PublicKeyCertificate certificate = (IX509PublicKeyCertificate)CertificateTools.createCertificate((Object)certificateValue);
                return certificate;
            }
            catch (CertificateException e) {
                throw new KeySelectorException(e);
            }
        }
        return null;
    }

    protected List<IX509PublicKeyCertificate> lookupCertificates(DOMStructure kiType) throws KeySelectorException {
        ArrayList<IX509PublicKeyCertificate> certificates = new ArrayList<IX509PublicKeyCertificate>();
        Element keyInfoElement = (Element)kiType.getNode();
        NodeList referenceElements = keyInfoElement.getElementsByTagNameNS(NS_WSSE, "Reference");
        for (int j = 0; j < referenceElements.getLength(); ++j) {
            Element referenceElement = (Element)referenceElements.item(j);
            String uri = referenceElement.getAttribute("URI");
            IX509PublicKeyCertificate certificate = this.lookupCertificateByBinarySecurityTokenURI(uri, keyInfoElement);
            if (certificate == null) continue;
            certificates.add(certificate);
        }
        return certificates;
    }

    protected List<IX509PublicKeyCertificate> lookupCertificates(X509Data kiType) {
        ArrayList<IX509PublicKeyCertificate> certificates = new ArrayList<IX509PublicKeyCertificate>();
        X509Data x509Data = kiType;
        for (Object o : x509Data.getContent()) {
            IX509PublicKeyCertificate cert;
            if (!(o instanceof X509Certificate) || (cert = X509CertificateFactory.get().createPublicKeyCertificate((X509Certificate)o)) == null) continue;
            certificates.add(cert);
        }
        return certificates;
    }

    protected List<IX509PublicKeyCertificate> lookupCertificates(XMLStructure kiType) throws KeySelectorException {
        if (kiType instanceof X509Data) {
            return this.lookupCertificates((X509Data)kiType);
        }
        if (kiType instanceof DOMStructure) {
            return this.lookupCertificates((DOMStructure)kiType);
        }
        return Collections.emptyList();
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        if (keyInfo == null) {
            throw new KeySelectorException("no KeyInfo element");
        }
        ArrayList<IX509PublicKeyCertificate> certificates = new ArrayList<IX509PublicKeyCertificate>();
        for (XMLStructure kiType : keyInfo.getContent()) {
            certificates.addAll(this.lookupCertificates(kiType));
        }
        if (certificates.isEmpty()) {
            throw new KeySelectorException("No X509Certificate found!");
        }
        return new CertificateChainResult(certificates);
    }

    public static final class CertificateChainResult
    implements KeySelectorResult {
        private List<IX509PublicKeyCertificate> certificates;

        public CertificateChainResult(List<IX509PublicKeyCertificate> certificates) {
            this.certificates = certificates;
        }

        public List<IX509PublicKeyCertificate> getCertificates() {
            return this.certificates;
        }

        @Override
        public Key getKey() {
            return this.certificates.get(0).getPublicKey();
        }
    }
}

