/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.attribute.encoder.IQualifyingPropertyEncoder;
import de.intarsys.security.method.xml.signature.ExclusiveCanonicalXMLTransformation;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilderCallback;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.XMLSignatureTarget;
import de.intarsys.security.method.xml.spec.XAdESBaseline;
import de.intarsys.tools.collection.FilterIterator;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.string.StringTools;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XAdESSignatureContainerBuilderCallback
implements IXMLSignatureContainerBuilderCallback {
    private static final String SUFFIX_SIGNED_PROPERTIES = "signedProperties";
    private static final String HASHMARK = "#";
    private final List<IQualifyingPropertyEncoder> propertyProviders = new ArrayList<IQualifyingPropertyEncoder>();

    public void addPropertyProvider(IQualifyingPropertyEncoder provider) {
        this.propertyProviders.add(provider);
    }

    @Override
    public void afterSign(XMLSignatureContainerBuilder builder, DOMSignContext context, Element signatureElement) throws MarshalException {
        Supplier<Element> qualifyingPropertiesSupplier = XAdESBaseline.getQualifyingPropertiesSupplier(() -> signatureElement);
        this.marshalUnsignedProperties(builder, context, qualifyingPropertiesSupplier);
    }

    @Override
    public void beforeSign(XMLSignatureContainerBuilder builder, DOMSignContext context) throws MarshalException {
        String dsPrefix = context.getParent().lookupPrefix("http://uri.etsi.org/01903/v1.3.2#");
        context.putNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", dsPrefix == null ? "xades132" : dsPrefix);
        this.marshallQualifyingProperties(builder, context, context.getParent().getOwnerDocument());
    }

    public List<IQualifyingPropertyEncoder> getPropertyProviders() {
        return new ArrayList<IQualifyingPropertyEncoder>(this.propertyProviders);
    }

    public List<IQualifyingPropertyEncoder> getSignedDataObjectPropertyProviders() {
        return ListTools.toList((Iterator)new FilterIterator<IQualifyingPropertyEncoder>(this.getPropertyProviders().iterator()){

            protected boolean accept(IQualifyingPropertyEncoder provider) {
                return provider.isSignedProperty() && !provider.isSignatureProperty();
            }
        });
    }

    public List<IQualifyingPropertyEncoder> getSignedSignaturePropertyProviders() {
        return ListTools.toList((Iterator)new FilterIterator<IQualifyingPropertyEncoder>(this.getPropertyProviders().iterator()){

            protected boolean accept(IQualifyingPropertyEncoder provider) {
                return provider.isSignedProperty() && provider.isSignatureProperty();
            }
        });
    }

    public List<IQualifyingPropertyEncoder> getUnsignedDataObjectPropertyProviders() {
        return ListTools.toList((Iterator)new FilterIterator<IQualifyingPropertyEncoder>(this.getPropertyProviders().iterator()){

            protected boolean accept(IQualifyingPropertyEncoder provider) {
                return !provider.isSignedProperty() && !provider.isSignatureProperty();
            }
        });
    }

    public List<IQualifyingPropertyEncoder> getUnsignedSignaturePropertyProviders() {
        return ListTools.toList((Iterator)new FilterIterator<IQualifyingPropertyEncoder>(this.getPropertyProviders().iterator()){

            protected boolean accept(IQualifyingPropertyEncoder provider) {
                return !provider.isSignedProperty() && provider.isSignatureProperty();
            }
        });
    }

    protected Node marshallQualifyingProperties(XMLSignatureContainerBuilder builder, DOMSignContext context, Document document) throws MarshalException {
        Element qualifyingProperties = DOMTools.createElement((Document)document, (String)"http://uri.etsi.org/01903/v1.3.2#", (String)context.getNamespacePrefix("http://uri.etsi.org/01903/v1.3.2#", "xades132"), (String)"QualifyingProperties");
        if (!StringTools.isEmpty((String)builder.getSignatureElementId())) {
            String targetId = HASHMARK + builder.getSignatureElementId();
            qualifyingProperties.setAttribute("Target", targetId);
        }
        String signedPropertiesId = DOMTools.createDerivedId((String)builder.getSignatureElementId(), (String)SUFFIX_SIGNED_PROPERTIES);
        this.marshalSignedProperties(builder, context, () -> qualifyingProperties, signedPropertiesId);
        List<DOMStructure> content = Collections.singletonList(new DOMStructure(qualifyingProperties));
        XMLObject xadesObject = builder.getSignatureFactory().newXMLObject(content, null, null, null);
        builder.addXMLObject(xadesObject);
        XMLSignatureTarget target = new XMLSignatureTarget(HASHMARK + signedPropertiesId);
        target.setType("http://uri.etsi.org/01903#SignedProperties");
        target.addTransformation(new ExclusiveCanonicalXMLTransformation());
        builder.addSignatureTarget(target);
        return qualifyingProperties;
    }

    protected void marshalSignedProperties(XMLSignatureContainerBuilder builder, DOMSignContext context, Supplier<Element> parentSupplier, String signedPropertiesId) throws MarshalException {
        Supplier<Element> signedPropertiesSupplier = XAdESBaseline.getSignedPropertiesSupplier(parentSupplier, signedPropertiesId);
        Supplier<Element> signedSignaturePropertiesSupplier = XAdESBaseline.getSignedSignaturePropertiesSupplier(signedPropertiesSupplier, null);
        for (IQualifyingPropertyEncoder provider : this.getSignedSignaturePropertyProviders()) {
            provider.marshal(builder.getSignatureFactory(), context, signedSignaturePropertiesSupplier);
        }
        Supplier<Element> signedDataObjectPropertiesSupplier = XAdESBaseline.getSignedDataObjectPropertiesSupplier(signedPropertiesSupplier, null);
        for (IQualifyingPropertyEncoder provider : this.getSignedDataObjectPropertyProviders()) {
            provider.marshal(builder.getSignatureFactory(), context, signedDataObjectPropertiesSupplier);
        }
    }

    protected void marshalUnsignedProperties(XMLSignatureContainerBuilder builder, DOMSignContext context, Supplier<Element> parentSupplier) throws MarshalException {
        Supplier<Element> unsignedPropertiesSupplier = XAdESBaseline.getUnsignedPropertiesSupplier(parentSupplier, null);
        Supplier<Element> unsignedSignaturePropertiesSupplier = XAdESBaseline.getUnsignedSignaturePropertiesSupplier(unsignedPropertiesSupplier, null);
        for (IQualifyingPropertyEncoder provider : this.getUnsignedSignaturePropertyProviders()) {
            provider.marshal(builder.getSignatureFactory(), context, unsignedSignaturePropertiesSupplier);
        }
        Supplier<Element> unsignedDataObjectPropertiesSupplier = XAdESBaseline.getUnsignedDataObjectPropertiesSupplier(unsignedPropertiesSupplier, null);
        for (IQualifyingPropertyEncoder provider : this.getUnsignedDataObjectPropertyProviders()) {
            provider.marshal(builder.getSignatureFactory(), context, unsignedDataObjectPropertiesSupplier);
        }
    }

    public void removePropertyProvider(IQualifyingPropertyEncoder provider) {
        this.propertyProviders.remove(provider);
    }
}

