/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.app.validation.BasicSignatureContainerValidator;
import de.intarsys.security.app.validation.ISignatureContainerValidator;
import de.intarsys.security.method.xml.signature.XMLSignatureEntry;
import de.intarsys.security.signature.AbstractSignatureContainer;
import de.intarsys.tools.attribute.Attribute;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.locator.ByteArrayLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorSupport;
import de.intarsys.tools.locator.LocatorByReference;
import de.intarsys.tools.xml.TransformerTools;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.ISXMLDSigRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLSignatureContainer
extends AbstractSignatureContainer<XMLSignatureEntry> {
    private static final Attribute ATTR_SIGNATURECONTAINERS = new Attribute("signatureContainers");
    private static final Logger Log = LoggerFactory.getLogger(XMLSignatureContainer.class);
    private static DocumentBuilderFactory documentBuilderFactory;
    private static XMLSignatureFactory xmlSignatureFactory;
    private ILocator externalSignedDataLocator;
    private ILocator locator;
    private String baseURI;
    private final List<XMLSignatureEntry> signatureEntries;
    private final Document xmlDocument;
    private boolean detached = false;

    public static XMLSignatureContainer createXMLSignatureContainer(Document document) {
        NodeList signatureNodeList = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        XMLSignatureContainer container = new XMLSignatureContainer(document, signatureNodeList);
        return container;
    }

    public static XMLSignatureContainer createXMLSignatureContainer(ILocator locator) throws IOException {
        Document document = null;
        try (InputStream is = locator.getInputStream();){
            document = XMLSignatureContainer.newDocumentBuilder().parse(is);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOException(e.getLocalizedMessage(), e);
        }
        XMLSignatureContainer container = XMLSignatureContainer.createXMLSignatureContainer(document);
        container.setLocator(locator);
        return container;
    }

    public static XMLSignatureContainer getSignatureContainer(Object signedData, ILocator signatureLocator) throws IOException {
        XMLSignatureContainer container = null;
        HashMap<ILocator, XMLSignatureContainer> containers = null;
        if (signedData instanceof IAttributeSupport) {
            containers = (HashMap<ILocator, XMLSignatureContainer>)((IAttributeSupport)signedData).getAttribute((Object)ATTR_SIGNATURECONTAINERS);
            if (containers == null) {
                containers = new HashMap<ILocator, XMLSignatureContainer>();
                ((IAttributeSupport)signedData).setAttribute((Object)ATTR_SIGNATURECONTAINERS, containers);
            } else {
                container = (XMLSignatureContainer)((Object)containers.get(signatureLocator));
            }
        }
        if (container == null) {
            container = XMLSignatureContainer.createXMLSignatureContainer(signatureLocator);
            if (signedData instanceof ILocatorSupport && !signatureLocator.equals(((ILocatorSupport)signedData).getLocator())) {
                LocatorByReference signedDataLocator = new LocatorByReference((ILocatorSupport)signedData);
                container.setExternalSignedDataLocator((ILocator)signedDataLocator);
            }
            if (containers != null) {
                containers.put(signatureLocator, container);
            }
        }
        return container;
    }

    public static XMLSignatureFactory getXmlSignatureFactory() {
        if (xmlSignatureFactory == null) {
            xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", new ISXMLDSigRI());
        }
        return xmlSignatureFactory;
    }

    private static DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        if (documentBuilderFactory == null) {
            documentBuilderFactory = DOMTools.createSecureDocumentBuilderFactory();
            documentBuilderFactory.setNamespaceAware(true);
        }
        return documentBuilderFactory.newDocumentBuilder();
    }

    protected XMLSignatureContainer(Document xmlDocument, NodeList signatureNodeList) {
        super((Object)xmlDocument);
        this.xmlDocument = xmlDocument;
        this.signatureEntries = this.createSignatureEntries(signatureNodeList);
    }

    public boolean containsManifests() {
        for (XMLSignatureEntry entry : this.getEntries()) {
            if (!entry.containsManifests()) continue;
            return true;
        }
        return false;
    }

    protected XMLSignatureEntry createEntry(Element element) {
        return new XMLSignatureEntry(this, element);
    }

    protected ISignatureContainerValidator createSignatureContainerValidator() {
        return new BasicSignatureContainerValidator();
    }

    protected List<XMLSignatureEntry> createSignatureEntries(NodeList signatureNodeList) {
        ArrayList<XMLSignatureEntry> result = new ArrayList<XMLSignatureEntry>(signatureNodeList.getLength());
        for (int i = 0; i < signatureNodeList.getLength(); ++i) {
            Element element = (Element)signatureNodeList.item(i);
            result.add(this.createEntry(element));
        }
        return result;
    }

    public String getBaseURI() {
        URI uri;
        if (this.baseURI != null) {
            return this.baseURI;
        }
        if (this.locator != null && (uri = this.locator.toURI()) != null) {
            return uri.toString();
        }
        return null;
    }

    public String getContentType() {
        return "text/xml";
    }

    public List<XMLSignatureEntry> getEntries() {
        return new ArrayList<XMLSignatureEntry>(this.signatureEntries);
    }

    public XMLSignatureEntry getEntry(Node signatureElement) {
        for (XMLSignatureEntry entry : this.getEntries()) {
            if (signatureElement != entry.getSignatureElement()) continue;
            return entry;
        }
        return null;
    }

    public ILocator getExternalSignedDataLocator() {
        return this.externalSignedDataLocator;
    }

    public ILocator getLocator() {
        if (this.locator == null) {
            byte[] transformedDocument = this.getTransformedDocument();
            this.locator = new ByteArrayLocator(transformedDocument, this.getTypedName());
        }
        return this.locator;
    }

    private byte[] getTransformedDocument() {
        try {
            Transformer transformer = TransformerTools.createSecureTransformerFactory().newTransformer();
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            transformer.transform(new DOMSource(this.xmlDocument), new StreamResult(out));
            return out.toByteArray();
        }
        catch (TransformerException e) {
            Log.error("Error serializing xml document:" + e.getLocalizedMessage(), (Throwable)e);
            return e.getLocalizedMessage().getBytes();
        }
    }

    public String getTypedName() {
        if (this.locator != null) {
            return this.locator.getName();
        }
        return "signature.xmldsig";
    }

    public boolean isDetached() {
        return this.detached;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public void setDetached(boolean detached) {
        this.detached = detached;
    }

    public void setExternalSignedDataLocator(ILocator signedDataLocator) {
        this.externalSignedDataLocator = signedDataLocator;
    }

    public void setLocator(ILocator locator) {
        this.locator = locator;
    }
}

