/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.IApplication;
import de.intarsys.security.app.SecurityApplicationException;
import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.app.validation.IValidationParameters;
import de.intarsys.security.app.validation.ValidationParameters;
import de.intarsys.security.certificate.CertificateTools;
import de.intarsys.security.certificate.IX509Certificate;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.device.IDevice;
import de.intarsys.security.jca.conversationsigner.ConversationSignerProvider;
import de.intarsys.security.method.common.signature.ISignatureContainerBuilder;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.method.xml.signature.ISignatureTarget;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.IXMLSignatureContainerBuilderCallback;
import de.intarsys.security.method.xml.signature.XMLSignatureContainer;
import de.intarsys.security.method.xml.signature.XMLSignatureEntry;
import de.intarsys.security.method.xml.signature.XMLSignerException;
import de.intarsys.security.signature.ISignatureContainerEntry;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.common.ISignatureData;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.security.validation.IValidationMessage;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.concurrent.Promise;
import de.intarsys.tools.concurrent.ThreadLocalSnapshot;
import de.intarsys.tools.concurrent.ThreadTools;
import de.intarsys.tools.conversation.IConversation;
import de.intarsys.tools.conversation.impl.Conversation;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.dom.NamespaceMapContext;
import de.intarsys.tools.string.StringTools;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Predicate;
import javax.xml.crypto.Data;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.URIDereferencer;
import javax.xml.crypto.URIReference;
import javax.xml.crypto.URIReferenceException;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathExpressionException;
import org.apache.jcp.xml.dsig.internal.dom.DefaultUriDereferencer;
import org.apache.jcp.xml.dsig.internal.dom.ISXMLDSigRI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.events.EventListener;
import org.w3c.dom.events.EventTarget;

public class XMLSignatureContainerBuilder
implements IXMLSignatureContainerBuilder {
    private static final String ALGO_EC = "EC";
    private static final String ALGO_ECDSA = "ECDSA";
    public static final String OBJ_HASH_ALGORITHM = "de.intarsys.method.xml.hashAlgorithm";
    public static final String OBJ_SIGNER_CERTIFICATE = "de.intarsys.method.xml.signerCertificate";
    public static final String OBJ_SIGNER_CERTIFICATE_PATH = "de.intarsys.method.xml.signerCertificatePath";
    public static final String PROPERTY_SIGNATURE_PROVIDER = "org.jcp.xml.dsig.internal.dom.SignatureProvider";
    public static final String OBJ_SIGNATURE_TIME_OFFSET = "de.intarsys.method.xml.signatureTimeOffset";
    public static final String OBJ_SIGNATURE_DATA = "de.intarsys.method.xml.signatureData";
    private static final Logger Log;
    private static final ExecutorService executor;
    private static final URIDereferencer DEREFERENCER;
    private Provider provider;
    private XMLSignatureFactory xmlSignatureFactory;
    private final List<ISignatureTarget> targets = new ArrayList<ISignatureTarget>();
    private List<XMLObject> xmlObjects;
    private final ISigner signer;
    private Document document;
    private int lastId = 0;
    private DigestAlgorithm hashAlgorithm = DigestAlgorithm.ALG_SHA1;
    private String parentNodeCreate;
    private String parentNodeLookup;
    private NamespaceMapContext namespaces;
    private String signatureValueId;
    private String signatureElementId;
    private EventListener signatureElementInsertListener;
    private Element signatureElement;
    private String baseUri;
    private IReviewer<ISignatureEntry, IVSSignatureEntry> signatureReviewer;
    private final List<IXMLSignatureContainerBuilderCallback> callbacks = new ArrayList<IXMLSignatureContainerBuilderCallback>();
    private final List<ISignatureContainerEntryProcessor> postProcessors = new ArrayList<ISignatureContainerEntryProcessor>();
    private DOMSignContext signContext;

    public XMLSignatureContainerBuilder(ISigner signer) {
        this.signer = signer;
    }

    public void addCallback(IXMLSignatureContainerBuilderCallback callback) {
        this.callbacks.add(callback);
    }

    public void addPostProcessor(ISignatureContainerEntryProcessor processor) {
        this.postProcessors.add(processor);
    }

    private void addSignatureElementInsertListener() {
        if (this.getDocument() instanceof EventTarget) {
            this.signatureElementInsertListener = evt -> {
                Node node = (Node)((Object)evt.getTarget());
                if ("Signature".equals(node.getLocalName())) {
                    this.signatureElement = (Element)node;
                }
            };
            ((EventTarget)((Object)this.getDocument())).addEventListener("DOMNodeInserted", this.signatureElementInsertListener, true);
        }
    }

    @Override
    public void addSignatureTarget(ISignatureTarget target) {
        this.targets.add(target);
    }

    public void addXMLObject(XMLObject xmlObject) {
        this.xmlObjects.add(xmlObject);
    }

    protected KeyInfo createKeyInfo() throws CertificateException {
        KeyInfoFactory keyInfoFactory = this.getSignatureFactory().getKeyInfoFactory();
        ArrayList<X509Certificate> x509DataContent = new ArrayList<X509Certificate>(this.getDigestSignerCertificatePath());
        String x509SubjectName = this.getSignerCertificate().getSubjectX500Principal().getName("RFC2253");
        x509DataContent.add((X509Certificate)((Object)x509SubjectName));
        X509Data x509Data = keyInfoFactory.newX509Data(x509DataContent);
        try {
            KeyValue keyValue = keyInfoFactory.newKeyValue(this.getSignerCertificate().getPublicKey());
            return keyInfoFactory.newKeyInfo(ListTools.with((Object[])new XMLStructure[]{x509Data, keyValue}));
        }
        catch (KeyException e) {
            Log.warn("skipping KeyInfo/KeyValue entry - cause: {}", (Object)e.getLocalizedMessage(), (Object)e);
            return keyInfoFactory.newKeyInfo(ListTools.with((Object[])new X509Data[]{x509Data}));
        }
    }

    protected Element createParentNode(Document document) throws XMLSignerException {
        Element parentNode = null;
        if (this.parentNodeLookup == null && this.parentNodeCreate == null) {
            parentNode = this.createParentNodeDocument(document);
        } else if (this.parentNodeLookup != null) {
            parentNode = this.createParentNodeLookup(document);
        }
        if (parentNode == null && this.parentNodeCreate != null) {
            parentNode = this.createParentNodeCreate(document);
        }
        if (parentNode == null) {
            throw new XMLSignerException("no parent node selected");
        }
        return parentNode;
    }

    protected Element createParentNodeCreate(Document document) {
        String[] pathElementNames;
        Element element = document.getDocumentElement();
        for (String elementName : pathElementNames = this.parentNodeCreate.split("/")) {
            Element newElement;
            if ((elementName = elementName.trim()).isEmpty()) continue;
            String[] name = elementName.split(":");
            if (name.length < 2) {
                newElement = document.createElement(name[0]);
            } else {
                String namespace = this.getNamespaces().get((Object)name[0]);
                newElement = document.createElementNS(namespace, name[1]);
            }
            if (element == null) {
                document.appendChild(newElement);
            } else {
                element.appendChild(newElement);
            }
            element = newElement;
        }
        return element;
    }

    protected Element createParentNodeDocument(Document document) {
        Element parentNode = document.getDocumentElement();
        return parentNode;
    }

    protected Element createParentNodeLookup(Document document) throws XMLSignerException {
        try {
            return (Element)DOMTools.selectNode((String)this.parentNodeLookup, (NamespaceContext)this.getNamespaces(), (Object)document);
        }
        catch (XPathExpressionException e) {
            if (e.getCause() != null) {
                throw new XMLSignerException(e.getCause().getLocalizedMessage(), e);
            }
            throw new XMLSignerException(e.getLocalizedMessage(), e);
        }
    }

    protected List<Reference> createReferences(DOMSignContext context) throws GeneralSecurityException {
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (ISignatureTarget target : this.getTargets()) {
            Reference ref = target.createReference(this, context);
            references.add(ref);
        }
        return references;
    }

    protected SignatureMethod createSignatureMethod() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        AlgorithmParameterSpec encAlgParams = this.getSigner().getAlgorithmParameterSpec();
        if (encAlgParams instanceof PSSParameterSpec) {
            return this.createSignatureMethodPSS((PSSParameterSpec)encAlgParams);
        }
        return this.createSignatureMethodDefault();
    }

    protected SignatureMethod createSignatureMethodDefault() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String encryptionAlgorithmName = this.getSignerCertificate().getPublicKey().getAlgorithm();
        DigestAlgorithm digestAlgorithm = this.getHashAlgorithm();
        Predicate<SignatureAlgorithm> pSignatureAlgorithm = algo -> {
            String algoName = algo.getEncryptionAlgorithm().getName();
            return algoName.equals(encryptionAlgorithmName) || ALGO_EC.equals(encryptionAlgorithmName) && algoName.equals(ALGO_ECDSA) || ALGO_ECDSA.equals(encryptionAlgorithmName) && algoName.equals(ALGO_EC);
        };
        Predicate<SignatureAlgorithm> pDigestAlgorithm = algo -> digestAlgorithm.equals((Object)algo.getDigestAlgorithm());
        String encodingAlgorithmName = "PSS";
        Predicate<SignatureAlgorithm> pEncodingAlgorithm = algo -> !encodingAlgorithmName.equals(algo.getEncodingAlgorithm().getName());
        SignatureAlgorithm signatureAlgorithm = XMLDSigTools.searchSignatureAlgorithm(pSignatureAlgorithm, pDigestAlgorithm, pEncodingAlgorithm);
        if (signatureAlgorithm == null) {
            throw new NoSuchAlgorithmException("signature algorithm " + encryptionAlgorithmName + ", hash algorithm " + this.getHashAlgorithm().getName());
        }
        String signatureAlgorithmName = signatureAlgorithm.getName();
        return this.getSignatureFactory().newSignatureMethod(signatureAlgorithmName, null);
    }

    protected SignatureMethod createSignatureMethodPSS(PSSParameterSpec pssParams) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        String encryptionAlgorithmName = this.getSignerCertificate().getPublicKey().getAlgorithm();
        DigestAlgorithm digestAlgorithm = DigestAlgorithm.lookupAlgorithmCanonical((String)pssParams.getDigestAlgorithm());
        Predicate<SignatureAlgorithm> pSignatureAlgorithm = algo -> {
            String algoName = algo.getEncryptionAlgorithm().getName();
            return algoName.equals(encryptionAlgorithmName) || ALGO_EC.equals(encryptionAlgorithmName) && algoName.equals(ALGO_ECDSA) || ALGO_ECDSA.equals(encryptionAlgorithmName) && algoName.equals(ALGO_EC);
        };
        Predicate<SignatureAlgorithm> pDigestAlgorithm = algo -> digestAlgorithm.equals((Object)algo.getDigestAlgorithm());
        String encodingAlgorithmName = "PSS";
        Predicate<SignatureAlgorithm> pEncodingAlgorithm = algo -> encodingAlgorithmName.equals(algo.getEncodingAlgorithm().getName());
        SignatureAlgorithm signatureAlgorithm = XMLDSigTools.searchSignatureAlgorithm(pSignatureAlgorithm, pDigestAlgorithm, pEncodingAlgorithm);
        if (signatureAlgorithm == null) {
            throw new NoSuchAlgorithmException("signature algorithm " + encryptionAlgorithmName + ", hash algorithm " + digestAlgorithm.getName());
        }
        String signatureAlgorithmName = signatureAlgorithm.getName();
        return this.getSignatureFactory().newSignatureMethod(signatureAlgorithmName, null);
    }

    protected DOMSignContext createSignContext(Element parentNode, ConversationSignerProvider jcaProvider) throws IOException {
        Key privateKey = this.getPrivateKey((Provider)jcaProvider);
        KeySelector keySelector = KeySelector.singletonKeySelector(privateKey);
        final DOMSignContext result = new DOMSignContext(keySelector, (Node)parentNode);
        result.setURIDereferencer(new URIDereferencer(){

            @Override
            public Data dereference(URIReference uriReference, XMLCryptoContext context) throws URIReferenceException {
                for (ISignatureTarget target : XMLSignatureContainerBuilder.this.getTargets()) {
                    Data data;
                    if (!(target instanceof URIDereferencer) || (data = ((URIDereferencer)((Object)target)).dereference(uriReference, result)) == null) continue;
                    return data;
                }
                return DEREFERENCER.dereference(uriReference, result);
            }
        });
        result.setBaseURI(this.getBaseUri());
        String dsPrefix = result.getParent().lookupPrefix("http://www.w3.org/2000/09/xmldsig#");
        result.putNamespacePrefix("http://www.w3.org/2000/09/xmldsig#", dsPrefix == null ? "ds" : dsPrefix);
        result.setProperty(PROPERTY_SIGNATURE_PROVIDER, jcaProvider);
        result.put(OBJ_HASH_ALGORITHM, this.getHashAlgorithm());
        result.put(OBJ_SIGNER_CERTIFICATE, this.getSignerCertificate());
        result.put(OBJ_SIGNER_CERTIFICATE_PATH, this.getSignerCertificatePath());
        result.put(OBJ_SIGNATURE_TIME_OFFSET, this.getSignatureTimeOffset());
        return result;
    }

    protected SignedInfo createSignedInfo(List<Reference> references, SignatureMethod signatureMethod) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CanonicalizationMethod c14n = this.getSignatureFactory().newCanonicalizationMethod("http://www.w3.org/2001/10/xml-exc-c14n#", (C14NMethodParameterSpec)null);
        return this.getSignatureFactory().newSignedInfo(c14n, signatureMethod, references);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public List<IXMLSignatureContainerBuilderCallback> getCallbacks() {
        return this.callbacks;
    }

    @Override
    public XMLCryptoContext getCryptoContext() {
        return this.signContext;
    }

    @Override
    public DigestMethod getDigestMethod(String pHashAlgorithmName) throws NoSuchAlgorithmException {
        String digestMethodName;
        String myHashAlgorithmName = pHashAlgorithmName;
        if (myHashAlgorithmName == null) {
            myHashAlgorithmName = this.getHashAlgorithm().getName();
        }
        if ((digestMethodName = XMLDSigTools.lookupDigestAlgorithm(myHashAlgorithmName).getName()) == null) {
            throw new NoSuchAlgorithmException("digest algorithm oid:" + myHashAlgorithmName);
        }
        try {
            return this.getSignatureFactory().newDigestMethod(digestMethodName, null);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new NoSuchAlgorithmException(e.getMessage(), e);
        }
    }

    protected List<X509Certificate> getDigestSignerCertificatePath() throws CertificateException {
        return Arrays.asList(CertificateTools.toJavaCerts((IX509Certificate[])this.getSigner().getCertificatePath()));
    }

    protected Document getDocument() {
        return this.document;
    }

    public DigestAlgorithm getHashAlgorithm() {
        return this.hashAlgorithm;
    }

    public NamespaceMapContext getNamespaces() {
        return this.namespaces;
    }

    public String getNextUniqueId() {
        ++this.lastId;
        return "obj-" + this.lastId;
    }

    public String getParentNodeCreate() {
        return this.parentNodeCreate;
    }

    public String getParentNodeLookup() {
        return this.parentNodeLookup;
    }

    public List<ISignatureContainerEntryProcessor> getPostProcessors() {
        return new ArrayList<ISignatureContainerEntryProcessor>(this.postProcessors);
    }

    private Key getPrivateKey(Provider jcaWrapper) throws IOException {
        try {
            KeyStore keyStore = KeyStore.getInstance("", jcaWrapper);
            keyStore.load(null);
            String alias = keyStore.aliases().nextElement();
            return keyStore.getKey(alias, null);
        }
        catch (Exception e) {
            throw new IOException("cannot find token", e);
        }
    }

    public Provider getProvider() {
        if (this.provider == null) {
            this.provider = ISXMLDSigRI.INSTANCE;
        }
        return this.provider;
    }

    public String getSignatureElementId() {
        return this.signatureElementId;
    }

    public XMLSignatureFactory getSignatureFactory() {
        if (this.xmlSignatureFactory == null) {
            try {
                this.xmlSignatureFactory = XMLSignatureFactory.getInstance("DOM", this.getProvider());
            }
            catch (Exception e) {
                throw new IllegalStateException(e.getLocalizedMessage(), e);
            }
        }
        return this.xmlSignatureFactory;
    }

    public IReviewer<ISignatureEntry, IVSSignatureEntry> getSignatureReviewer() {
        return this.signatureReviewer;
    }

    protected long getSignatureTimeOffset() {
        IDevice device = Optional.ofNullable(this.getSigner()).map(IApplication::getDevice).orElse(null);
        if (device != null) {
            try {
                Long pdfSignatureTimeOffset = (Long)device.getValue("pdfSignatureTimeOffset");
                if (pdfSignatureTimeOffset != null) {
                    return pdfSignatureTimeOffset;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public String getSignatureValueId() {
        return this.signatureValueId;
    }

    public ISigner getSigner() {
        return this.signer;
    }

    protected IX509PublicKeyCertificate getSignerCertificate() {
        return this.getSignerCertificatePath()[0];
    }

    protected IX509PublicKeyCertificate[] getSignerCertificatePath() {
        return this.getSigner().getCertificatePath();
    }

    public List<ISignatureTarget> getTargets() {
        return this.targets;
    }

    protected void hookSignAfter(DOMSignContext signContext) throws MarshalException {
        for (IXMLSignatureContainerBuilderCallback callback : this.getCallbacks()) {
            callback.afterSign(this, signContext, this.signatureElement);
        }
    }

    protected void hookSignBefore(DOMSignContext signContext) throws MarshalException {
        for (IXMLSignatureContainerBuilderCallback callback : this.getCallbacks()) {
            callback.beforeSign(this, signContext);
        }
    }

    protected void postProcess(ISignatureContainerEntry signature, DOMSignContext context) throws SecurityApplicationException, IOException {
        ISignatureData signatureData = (ISignatureData)context.get(OBJ_SIGNATURE_DATA);
        for (ISignatureContainerEntryProcessor processor : this.getPostProcessors()) {
            processor.process((ISignatureContainerBuilder)this, signature, signatureData);
        }
    }

    protected void postProcess(XMLSignatureContainer container, DOMSignContext context) throws SecurityApplicationException, IOException {
        for (XMLSignatureEntry entry : container.getEntries()) {
            this.postProcess((ISignatureContainerEntry)entry, context);
        }
    }

    @PostConstruct
    public void prepare() {
        if (StringTools.isEmpty((String)this.getSignatureElementId())) {
            this.setSignatureElementId(DOMTools.createId((String)"signature"));
        }
    }

    private void removeSignatureElementInsertListener() {
        if (this.getDocument() instanceof EventTarget && this.signatureElementInsertListener != null) {
            ((EventTarget)((Object)this.getDocument())).removeEventListener("DOMNodeInserted", this.signatureElementInsertListener, true);
        }
    }

    protected void reviewSignature(XMLSignatureContainer signatureContainer) throws GeneralSecurityException {
        if (this.getSignatureReviewer() == null) {
            return;
        }
        XMLSignatureEntry signatureEntry = signatureContainer.getEntry(this.signatureElement);
        if (signatureEntry == null) {
            return;
        }
        Log.debug("Reviewing signature.");
        IVSSignatureEntry state = (IVSSignatureEntry)this.getSignatureReviewer().review((Object)signatureEntry, null, (IValidationParameters)new ValidationParameters());
        Log.debug("Signature review result: {}", (Object)state.getState());
        StringBuilder sb = new StringBuilder();
        for (IValidationMessage message : state.getMessages()) {
            if (message.isInfo()) {
                sb.append("INFO: ").append(message.getText());
            } else if (message.isWarning()) {
                sb.append("WARNING: ").append(message.getText());
            } else if (message.isError()) {
                sb.append("ERROR: ").append(message.getText());
            }
            sb.append(StringTools.LS);
        }
        Log.debug(sb.toString());
        if (state.isInvalid()) {
            throw new GeneralSecurityException("Signature review failed:" + StringTools.LS + sb.toString());
        }
    }

    protected void rollbackSignatureElement() {
        if (this.signatureElement != null) {
            Node parent = this.signatureElement.getParentNode();
            parent.removeChild(this.signatureElement);
            this.signatureElement = null;
        }
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setHashAlgorithm(DigestAlgorithm hashAlgorithm) {
        if (hashAlgorithm == null) {
            return;
        }
        this.hashAlgorithm = hashAlgorithm;
    }

    public void setNamespaces(Map<String, String> namespaces) {
        this.namespaces = new NamespaceMapContext(namespaces);
    }

    public void setParentNodeCreate(String parentNodeCreate) {
        this.parentNodeCreate = parentNodeCreate;
    }

    public void setParentNodeLookup(String parentNodeLookup) {
        this.parentNodeLookup = parentNodeLookup;
    }

    public void setProvider(Provider provider) {
        this.provider = provider;
    }

    @Override
    public void setSignatureElementId(String signatureElementId) {
        this.signatureElementId = signatureElementId;
    }

    public void setSignatureFactory(XMLSignatureFactory xmlSignatureFactory) {
        this.xmlSignatureFactory = xmlSignatureFactory;
    }

    public void setSignatureReviewer(IReviewer<ISignatureEntry, IVSSignatureEntry> signatureReviewer) {
        this.signatureReviewer = signatureReviewer;
    }

    public void setSignatureValueId(String signatureValueId) {
        this.signatureValueId = signatureValueId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IConversation<XMLSignatureContainer> sign(Document document) {
        this.document = document;
        this.xmlObjects = new ArrayList<XMLObject>();
        this.signatureElement = null;
        final Promise jcaFinished = new Promise();
        try {
            Element parentNode = this.createParentNode(document);
            this.addSignatureElementInsertListener();
            this.getSigner().setHashAlgorithmName(this.getHashAlgorithm().getCanonicalName());
            ConversationSignerProvider jcaProvider = new ConversationSignerProvider(this.getSigner());
            this.signContext = this.createSignContext(parentNode, jcaProvider);
            this.hookSignBefore(this.signContext);
            for (Map.Entry entry : this.getNamespaces().entrySet()) {
                this.signContext.putNamespacePrefix((String)entry.getValue(), (String)entry.getKey());
            }
            List<Reference> references = this.createReferences(this.signContext);
            SignatureMethod signatureMethod = this.createSignatureMethod();
            SignedInfo signedInfo = this.createSignedInfo(references, signatureMethod);
            KeyInfo keyInfo = this.createKeyInfo();
            final XMLSignature xmlSignature = this.getSignatureFactory().newXMLSignature(signedInfo, keyInfo, this.xmlObjects, this.getSignatureElementId(), this.getSignatureValueId());
            final ThreadLocalSnapshot snapshot = ThreadLocalSnapshot.create();
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    Log.debug("creating signature with id={}", (Object)XMLSignatureContainerBuilder.this.getSignatureElementId());
                    try {
                        snapshot.paste();
                        xmlSignature.sign(XMLSignatureContainerBuilder.this.signContext);
                        jcaFinished.finish(null);
                    }
                    catch (Exception e) {
                        jcaFinished.fail((Throwable)e);
                    }
                    finally {
                        snapshot.remove();
                    }
                }
            });
            IConversation iConversation = jcaProvider.getSignConversation().thenApply(signatureData -> {
                this.signContext.put(OBJ_SIGNATURE_DATA, signatureData);
                jcaFinished.get();
                this.hookSignAfter(this.signContext);
                XMLSignatureContainer container = XMLSignatureContainer.createXMLSignatureContainer(document);
                this.postProcess(container, this.signContext);
                this.reviewSignature(container);
                return container;
            }).exceptionally(e -> {
                this.rollbackSignatureElement();
                if (e.getCause() instanceof SignatureException && e.getCause().getCause() instanceof SecurityApplicationException) {
                    throw (SecurityApplicationException)e.getCause().getCause();
                }
                throw new XMLSignerException(e.getLocalizedMessage(), (Throwable)e);
            });
            return iConversation;
        }
        catch (Exception e2) {
            this.rollbackSignatureElement();
            IConversation iConversation = Conversation.failed((Throwable)new XMLSignerException(e2.getLocalizedMessage(), e2));
            return iConversation;
        }
        finally {
            this.removeSignatureElementInsertListener();
        }
    }

    static {
        System.setProperty("org.apache.xml.security.ignoreLineBreaks", Boolean.TRUE.toString());
        Log = LoggerFactory.getLogger(XMLSignatureContainerBuilder.class);
        executor = Executors.newCachedThreadPool(ThreadTools.newThreadFactoryDaemon((String)"XML signer thread"));
        DEREFERENCER = new DefaultUriDereferencer();
    }
}

