/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.app.signature.ISignatureContainerEntryProcessor;
import de.intarsys.security.app.signature.ISigner;
import de.intarsys.security.app.timestamp.ITimestampCreator;
import de.intarsys.security.app.validation.IReviewer;
import de.intarsys.security.method.common.signature.AdESEnvironment;
import de.intarsys.security.method.common.signature.AdESSignerTools;
import de.intarsys.security.method.xml.attribute.encoder.CommitmentTypeIndicationEncoder;
import de.intarsys.security.method.xml.attribute.encoder.SignaturePolicyIdentifierEncoder;
import de.intarsys.security.method.xml.attribute.encoder.SignatureTimeStampEncoder;
import de.intarsys.security.method.xml.attribute.encoder.SignerRoleV2Encoder;
import de.intarsys.security.method.xml.attribute.encoder.SigningCertificateEncoder;
import de.intarsys.security.method.xml.attribute.encoder.SigningCertificateV2Encoder;
import de.intarsys.security.method.xml.attribute.encoder.SigningTimeEncoder;
import de.intarsys.security.method.xml.signature.CommonXMLSignatureContainerBuilderFactory;
import de.intarsys.security.method.xml.signature.XAdESSignatureContainerBuilderCallback;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import de.intarsys.security.method.xml.signature.XMLSignerTools;
import de.intarsys.security.method.xml.validation.XMLValidationDataExtender;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.ValidationDataOptions;
import de.intarsys.security.signature.etsi.api.ConformanceLevel;
import de.intarsys.security.signature.etsi.api.SignatureFormat;
import de.intarsys.security.signature.etsi.service.SignatureCreationService;
import de.intarsys.security.signature.policy.ICommitmentTypeIndication;
import de.intarsys.security.signature.policy.IPolicyReference;
import de.intarsys.security.signature.policy.SignaturePolicyValidator;
import de.intarsys.security.validation.IVSSignatureEntry;
import de.intarsys.tools.collection.ListTools;
import de.intarsys.tools.component.SingletonProvider;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import de.intarsys.tools.servicelocator.ServiceLocator;
import java.util.List;

@SingletonProvider
public class XMLSignatureContainerBuilderFactoryXAdES
extends CommonXMLSignatureContainerBuilderFactory {
    public static XMLSignatureContainerBuilderFactoryXAdES get() {
        return (XMLSignatureContainerBuilderFactoryXAdES)((Object)ServiceLocator.get().get(XMLSignatureContainerBuilderFactoryXAdES.class));
    }

    public String getLabel() {
        return "XAdES baseline";
    }

    @Override
    protected void prepareDigestSigner(ISigner signer, IArgs args) throws ObjectCreationException {
        super.prepareDigestSigner(signer, args);
        signer.setSignatureFormat(SignatureFormat.XAdES);
    }

    @Override
    protected void prepareXMLSigner(XMLSignatureContainerBuilder builder, IArgs args) throws ObjectCreationException {
        ValidationDataOptions options;
        ConformanceLevel level;
        List attrCerts;
        ICommitmentTypeIndication commitmentTypeIndication;
        super.prepareXMLSigner(builder, args);
        XAdESSignatureContainerBuilderCallback callback = new XAdESSignatureContainerBuilderCallback();
        builder.addCallback(callback);
        callback.addPropertyProvider(new SigningTimeEncoder());
        if (XMLSignerTools.isETSI_119_132(args)) {
            callback.addPropertyProvider(new SigningCertificateEncoder());
        } else {
            callback.addPropertyProvider(new SigningCertificateV2Encoder());
        }
        IPolicyReference signaturePolicy = AdESSignerTools.getSignaturePolicy((IArgs)args);
        if (signaturePolicy != null) {
            callback.addPropertyProvider(new SignaturePolicyIdentifierEncoder(signaturePolicy));
            IReviewer policyValidator = SignaturePolicyValidator.create((IPolicyReference)signaturePolicy);
            builder.setSignatureReviewer((IReviewer<ISignatureEntry, IVSSignatureEntry>)policyValidator);
        }
        if ((commitmentTypeIndication = AdESSignerTools.getCommitmentTypeIndication((IArgs)args)) != null) {
            callback.addPropertyProvider(new CommitmentTypeIndicationEncoder(ListTools.with((Object[])new ICommitmentTypeIndication[]{commitmentTypeIndication})));
        }
        if (!(attrCerts = AdESSignerTools.getAttributeCertificates((IArgs)args)).isEmpty()) {
            callback.addPropertyProvider(new SignerRoleV2Encoder(attrCerts));
        }
        if ((level = SignatureCreationService.getConformanceLevel((IArgs)args, null)) == null || level.isTimestampRequired()) {
            boolean enforceTimestamp;
            ITimestampCreator tsService = AdESSignerTools.createTimestampCreator((IArgs)args);
            boolean bl = enforceTimestamp = level != null && level.isTimestampRequired();
            if (enforceTimestamp && tsService == null) {
                tsService = AdESEnvironment.get().createDefaultTimestampCreator();
            }
            SignatureTimeStampEncoder timestampEncoder = new SignatureTimeStampEncoder(tsService);
            timestampEncoder.setEnforceTimestamp(enforceTimestamp);
            callback.addPropertyProvider(timestampEncoder);
        }
        if ((options = AdESSignerTools.getValidationDataOptions((IArgs)args)).isAddValidationData()) {
            XMLValidationDataExtender extender = new XMLValidationDataExtender();
            extender.setValidationDataOptions(options);
            extender.setFailOnError(false);
            builder.addPostProcessor((ISignatureContainerEntryProcessor)extender);
        }
    }
}

