/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.algorithm.common.Algorithm;
import de.intarsys.security.algorithm.common.AlgorithmSpec;
import de.intarsys.security.algorithm.common.DigestAlgorithm;
import de.intarsys.security.algorithm.common.SignatureAlgorithm;
import de.intarsys.security.app.validation.ISignatureContainerEntryDefaultStateFactory;
import de.intarsys.security.app.validation.ISignatureContainerEntryExtender;
import de.intarsys.security.app.validation.ISignatureEntryValidator;
import de.intarsys.security.app.validation.common.SignatureEntryDefaultStateFactory;
import de.intarsys.security.certificate.IX509PublicKeyCertificate;
import de.intarsys.security.method.xml.common.XMLDSigTools;
import de.intarsys.security.method.xml.signature.AttributesFilter;
import de.intarsys.security.method.xml.signature.QualifyingProperties;
import de.intarsys.security.method.xml.signature.X509DataKeySelector;
import de.intarsys.security.method.xml.signature.XMLSignatureContainer;
import de.intarsys.security.method.xml.validation.XMLSignatureEntryValidator;
import de.intarsys.security.method.xml.validation.XMLValidationDataExtender;
import de.intarsys.security.signature.ISignatureEntry;
import de.intarsys.security.signature.attribute.EmptyAttributeMap;
import de.intarsys.security.signature.attribute.IAttributeMap;
import de.intarsys.security.signature.attribute.ISigningTimeAttribute;
import de.intarsys.tools.adapter.IAdapterSupport;
import de.intarsys.tools.attribute.AttributeMap;
import de.intarsys.tools.attribute.IAttributeSupport;
import de.intarsys.tools.digest.IDigest;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.string.StringTools;
import jakarta.xml.bind.DatatypeConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import org.apache.jcp.xml.dsig.internal.dom.Utils;
import org.apache.xml.security.c14n.CanonicalizationException;
import org.apache.xml.security.signature.XMLSignatureInput;
import org.apache.xml.security.utils.IdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLSignatureEntry
implements ISignatureEntry,
IAdapterSupport {
    public static final String REFERENCE_TYPE_SIGNED_PROPERTIES_132 = "http://uri.etsi.org/01903/v1.3.2#SignedProperties";
    public static final String REFERENCE_TYPE_SIGNED_PROPERTIES = "http://uri.etsi.org/01903#SignedProperties";
    private static final Logger Log = LoggerFactory.getLogger(XMLSignatureEntry.class);
    private final IAttributeSupport attributeSupport = new AttributeMap();
    private final XMLSignatureContainer signatureContainer;
    private final Element signatureElement;
    private Optional<QualifyingProperties> qualifyingProperties;
    private List<IX509PublicKeyCertificate> certificates;
    private XMLSignature xmlSignature;

    protected XMLSignatureEntry(XMLSignatureContainer container, Element signatureElement) {
        this.signatureContainer = container;
        this.signatureElement = signatureElement;
    }

    private Element basicGetSignedPropertiesElement(Reference reference) {
        String uri = reference.getURI();
        if (!Utils.sameDocumentURI((String)uri)) {
            return null;
        }
        String id = Utils.parseIdFromSameDocumentURI((String)uri);
        if (id == null) {
            return null;
        }
        Element signedProperties = IdResolver.getElementById((Document)this.signatureElement.getOwnerDocument(), (String)id);
        if (signedProperties == null) {
            return null;
        }
        return signedProperties;
    }

    private boolean checkQualifyingPropertiesTarget(Element qualifyingProperties) {
        String targetUri = qualifyingProperties.getAttribute("Target");
        if (targetUri == null) {
            Log.debug("'Target' attribute is missing on <QualifyingProperties> element.");
            return false;
        }
        if (!Utils.sameDocumentURI((String)targetUri)) {
            Log.debug("'Target' attribute on <QualifyingProperties> element does not point to the same document.");
            return false;
        }
        String targetId = Utils.parseIdFromSameDocumentURI((String)targetUri);
        if (!targetId.equals(this.getSignatureId())) {
            Log.debug("'Target' attribute value on <QualifyingProperties> element refers to a different signature ID.");
        }
        return true;
    }

    public boolean containsManifests() {
        if (this.getXmlSignature() != null) {
            for (Reference reference : this.getXmlSignature().getSignedInfo().getReferences()) {
                if (!"http://www.w3.org/2000/09/xmldsig#Manifest".equals(reference.getType())) continue;
                return true;
            }
        }
        return false;
    }

    private DOMValidateContext createValidateContext() {
        DOMValidateContext context = new DOMValidateContext(new X509DataKeySelector(), (Node)this.signatureElement);
        context.setProperty("org.jcp.xml.dsig.secureValidation", Boolean.TRUE);
        return context;
    }

    public <T> T getAdapter(Class<T> type) {
        if (type == ISignatureEntryValidator.class) {
            return type.cast((Object)new XMLSignatureEntryValidator());
        }
        if (type == ISignatureContainerEntryDefaultStateFactory.class) {
            return type.cast(new SignatureEntryDefaultStateFactory());
        }
        if (type == ISignatureContainerEntryExtender.class) {
            return type.cast((Object)new XMLValidationDataExtender());
        }
        return null;
    }

    public List<IX509PublicKeyCertificate> getAdditionalCertificates() {
        if (this.getCertificates().size() > 1) {
            return new ArrayList<IX509PublicKeyCertificate>(this.getCertificates().subList(1, this.getCertificates().size()));
        }
        return Collections.emptyList();
    }

    public final Object getAttribute(Object key) {
        return this.attributeSupport.getAttribute(key);
    }

    public List<IX509PublicKeyCertificate> getCertificates() {
        if (this.certificates == null) {
            this.certificates = this.initCertificates();
        }
        return this.certificates;
    }

    public String getContentType() {
        return null;
    }

    public Date getCreationDate() {
        return this.getSigningTime();
    }

    public AlgorithmSpec<DigestAlgorithm> getHashAlgorithmSpec() {
        DigestAlgorithm digestAlgorithm;
        SignatureAlgorithm signatureAlgorithm;
        String sigAlgo = this.getSignatureAlgorithmName();
        if (!StringTools.isEmpty((String)sigAlgo) && (signatureAlgorithm = XMLDSigTools.lookupSignatureAlgorithmByXMLName(sigAlgo)) != null && (digestAlgorithm = signatureAlgorithm.getDigestAlgorithm()) != null) {
            return new AlgorithmSpec((Algorithm)digestAlgorithm);
        }
        return null;
    }

    public Object getImpl() {
        return this.getXmlSignature();
    }

    public String getLocation() {
        return null;
    }

    public Optional<QualifyingProperties> getQualifyingProperties() {
        if (this.qualifyingProperties == null) {
            this.qualifyingProperties = this.initQualifyingProperties();
        }
        return this.qualifyingProperties;
    }

    private Element getQualifyingPropertiesElement(Reference reference) {
        Element signedPropertiesElement = this.getSignedPropertiesElement(reference);
        if (signedPropertiesElement == null) {
            return null;
        }
        return (Element)signedPropertiesElement.getParentNode();
    }

    public String getReason() {
        return null;
    }

    public String getSignatureAlgorithmName() {
        NodeList nodeList = this.getSignatureElement().getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureMethod");
        if (nodeList.getLength() == 0) {
            return null;
        }
        Element signatureMethodElement = (Element)nodeList.item(0);
        String algorithm = signatureMethodElement.getAttribute("Algorithm");
        return algorithm.isEmpty() ? null : algorithm;
    }

    public AlgorithmSpec<SignatureAlgorithm> getSignatureAlgorithmSpec() {
        String algorithmName = this.getSignatureAlgorithmName();
        SignatureAlgorithm algorithm = XMLDSigTools.lookupSignatureAlgorithmByXMLName(algorithmName);
        return algorithm == null ? null : new AlgorithmSpec((Algorithm)algorithm);
    }

    public XMLSignatureContainer getSignatureContainer() {
        return this.signatureContainer;
    }

    public Element getSignatureElement() {
        return this.signatureElement;
    }

    public byte[] getSignatureEncoded() {
        Element signatureValue = this.getSignatureValueElement();
        String text = signatureValue.getTextContent();
        return Base64.getDecoder().decode(text);
    }

    public String getSignatureId() {
        if (this.getXmlSignature() != null) {
            return this.getXmlSignature().getId();
        }
        return null;
    }

    private Element getSignatureValueElement() {
        NodeList nodeList = this.signatureElement.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "SignatureValue");
        return (Element)nodeList.item(0);
    }

    public IAttributeMap getSignedAttributes() {
        return this.getQualifyingProperties().map(AttributesFilter.SignedProperties::new).orElse((IAttributeMap)EmptyAttributeMap.INSTANCE);
    }

    public IDigest getSignedContentDigest() {
        return null;
    }

    public ILocator getSignedDocument() {
        return null;
    }

    private Element getSignedPropertiesElement(Reference reference) {
        Element element = this.basicGetSignedPropertiesElement(reference);
        if (element == null || this.isReferenceTypeSignedProperties(reference.getType())) {
            return element;
        }
        if ("http://uri.etsi.org/01903/v1.3.2#".equals(element.getNamespaceURI()) && "SignedProperties".equals(element.getLocalName())) {
            return element;
        }
        return null;
    }

    public IX509PublicKeyCertificate getSignerCertificate() {
        if (!this.getCertificates().isEmpty()) {
            return this.getCertificates().get(0);
        }
        return null;
    }

    public Date getSigningTime() {
        try {
            ISigningTimeAttribute signingTime = (ISigningTimeAttribute)this.getSignedAttributes().get("1.2.840.113549.1.9.5");
            if (signingTime != null) {
                return signingTime.getTime();
            }
        }
        catch (IOException e) {
            Log.error("failed parsing attribute 'SigningTime': {}", (Object)e.getLocalizedMessage(), (Object)e);
        }
        return this.getWsuTimestamp();
    }

    public byte[] getTimestampInput() {
        try {
            Element signatureValue = this.getSignatureValueElement();
            XMLSignatureInput result = new XMLSignatureInput((Node)signatureValue);
            result.setExcludeComments(true);
            return result.getBytes();
        }
        catch (IOException | CanonicalizationException e) {
            Log.error("failed parsing element 'SignatureValue': {}", (Object)e.getLocalizedMessage(), (Object)e);
            return null;
        }
    }

    public IAttributeMap getUnsignedAttributes() {
        return this.getQualifyingProperties().map(AttributesFilter.UnsignedProperties::new).orElse((IAttributeMap)EmptyAttributeMap.INSTANCE);
    }

    protected Date getWsuTimestamp() {
        if (!(this.signatureElement.getParentNode() instanceof Element)) {
            return null;
        }
        Element securityElement = (Element)this.signatureElement.getParentNode();
        NodeList timestampElements = securityElement.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Timestamp");
        if (timestampElements.getLength() == 0) {
            return null;
        }
        Element timestampElement = (Element)timestampElements.item(0);
        NodeList createdElements = timestampElement.getElementsByTagNameNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Created");
        if (createdElements.getLength() == 0) {
            return null;
        }
        Element createdElement = (Element)createdElements.item(0);
        return DatatypeConverter.parseDateTime((String)createdElement.getTextContent()).getTime();
    }

    protected XMLSignature getXmlSignature() {
        if (this.xmlSignature == null) {
            DOMValidateContext validateContext = this.createValidateContext();
            try {
                this.xmlSignature = XMLSignatureContainer.getXmlSignatureFactory().unmarshalXMLSignature(validateContext);
            }
            catch (MarshalException e) {
                Log.warn("Couldn't parse signature element: {}", (Object)e.getLocalizedMessage(), (Object)e);
            }
        }
        return this.xmlSignature;
    }

    public String getXPathToSignatureNode() {
        StringBuilder path = new StringBuilder("/");
        path.append(this.signatureElement.getNodeName());
        Node node = this.signatureElement;
        while ((node = node.getParentNode()) != this.signatureElement.getOwnerDocument()) {
            path.insert(0, node.getNodeName());
            path.insert(0, "/");
        }
        if (this.getSignatureId() != null) {
            path.append("[@Id=\"");
            path.append(this.getSignatureId());
            path.append("\"]");
        } else {
            int nodeIndex = 0;
            node = this.signatureElement;
            while ((node = node.getPreviousSibling()) != null) {
                if (!"signature".equalsIgnoreCase(node.getLocalName())) continue;
                ++nodeIndex;
            }
            path.append("[");
            path.append(nodeIndex);
            path.append("]");
        }
        return path.toString();
    }

    private List<IX509PublicKeyCertificate> initCertificates() {
        if (this.getXmlSignature() != null) {
            KeyInfo keyInfo = this.getXmlSignature().getKeyInfo();
            try {
                KeySelectorResult keySelectorResult = new X509DataKeySelector().select(keyInfo, null, null, null);
                if (keySelectorResult != null) {
                    return ((X509DataKeySelector.CertificateChainResult)keySelectorResult).getCertificates();
                }
            }
            catch (KeySelectorException e) {
                return Collections.emptyList();
            }
        }
        return Collections.emptyList();
    }

    private Optional<QualifyingProperties> initQualifyingProperties() {
        if (this.getXmlSignature() != null) {
            List<Reference> references = this.getXmlSignature().getSignedInfo().getReferences();
            for (Reference reference : references) {
                Element qualifyingProperties = this.getQualifyingPropertiesElement(reference);
                if (qualifyingProperties == null) continue;
                if (!this.checkQualifyingPropertiesTarget(qualifyingProperties)) {
                    return Optional.empty();
                }
                return Optional.of(new QualifyingProperties(qualifyingProperties));
            }
        }
        return Optional.empty();
    }

    private boolean isReferenceTypeSignedProperties(String type) {
        return REFERENCE_TYPE_SIGNED_PROPERTIES.equals(type) || REFERENCE_TYPE_SIGNED_PROPERTIES_132.equals(type);
    }

    public final Object removeAttribute(Object key) {
        return this.attributeSupport.removeAttribute(key);
    }

    public final Object setAttribute(Object key, Object o) {
        return this.attributeSupport.setAttribute(key, o);
    }
}

