/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.AbstractSignatureTarget;
import de.intarsys.security.method.xml.signature.ITransformation;
import de.intarsys.security.method.xml.signature.Transformation;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.dom.DOMSignContext;

public class XMLSignatureTarget
extends AbstractSignatureTarget {
    private String referenceUri;
    private final List<Transformation> transformations;
    private String type;

    public XMLSignatureTarget() {
        this("");
    }

    public XMLSignatureTarget(String referenceUri) {
        this.referenceUri = referenceUri;
        if (this.referenceUri == null) {
            this.referenceUri = "";
        }
        this.transformations = new ArrayList<Transformation>(3);
    }

    public void addTransformation(ITransformation transformation) {
        this.transformations.add((Transformation)transformation);
    }

    @Override
    public Reference createReference(XMLSignatureContainerBuilder builder, DOMSignContext context) throws GeneralSecurityException {
        DigestMethod digestMethod = this.getDigestMethod(builder);
        List<Transform> transforms = this.getTransforms(builder, context);
        return builder.getSignatureFactory().newReference(this.referenceUri, digestMethod, transforms, this.getType(), null);
    }

    private List<Transform> getTransforms(XMLSignatureContainerBuilder xmlSigner, DOMSignContext context) throws InvalidAlgorithmParameterException {
        ArrayList<Transform> transforms = new ArrayList<Transform>(this.transformations.size());
        for (Transformation t : this.transformations) {
            transforms.add(t.toTransform(xmlSigner, context));
        }
        return transforms;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }
}

