/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.ISignatureTarget;
import de.intarsys.security.method.xml.signature.ITransformation;
import de.intarsys.security.method.xml.signature.TransformationFactory;
import de.intarsys.security.method.xml.signature.XMLSignatureTarget;
import de.intarsys.tools.functor.ArgTools;
import de.intarsys.tools.functor.Args;
import de.intarsys.tools.functor.IArgs;
import de.intarsys.tools.reflect.ObjectCreationException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.Map;

public final class XMLSignerTools {
    private static final TransformationFactory transformationFactory = new TransformationFactory();
    public static final String TRANSFORM_ALGORITHM = "algorithm";
    public static final String TRANSFORM_EXPRESSION = "expression";
    public static final String TRANSFORM_FILTER = "filter";
    public static final String REFERENCE_TRANSFORMS = "transforms";
    public static final String REFERENCE_URI = "uri";

    public static ISignatureTarget createSignatureTarget(IArgs reference) throws ObjectCreationException {
        String uri = null;
        if (reference != null) {
            uri = (String)reference.get(REFERENCE_URI);
        }
        XMLSignatureTarget target = new XMLSignatureTarget(uri);
        IArgs transforms = ArgTools.getArgs((IArgs)reference, (String)REFERENCE_TRANSFORMS, (IArgs)Args.create());
        for (int j = 0; j < transforms.size(); ++j) {
            IArgs transform = ArgTools.toArgs((Object)transforms.get(j));
            ITransformation t = XMLSignerTools.createTransformation(transform);
            target.addTransformation(t);
        }
        return target;
    }

    public static ITransformation createTransformation(IArgs transform) throws ObjectCreationException {
        String algorithm = ArgTools.getString((IArgs)transform, (String)TRANSFORM_ALGORITHM, null);
        String filter = ArgTools.getString((IArgs)transform, (String)TRANSFORM_FILTER, null);
        String expression = ArgTools.getString((IArgs)transform, (String)TRANSFORM_EXPRESSION, null);
        try {
            return transformationFactory.createTransformation(algorithm, filter, expression);
        }
        catch (NoSuchAlgorithmException e) {
            throw new ObjectCreationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static String getBaseUri(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"baseUri", null);
    }

    public static Map<String, String> getNamespaces(IArgs args) {
        return ArgTools.getMap((IArgs)args, (String)"namespaces", Collections.emptyMap());
    }

    public static String getParentNodeCreate(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"parentNodeCreate", null);
    }

    public static String getParentNodeLookup(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"parentNodeLookup", null);
    }

    public static String getSignatureElementId(IArgs args) {
        return ArgTools.getString((IArgs)args, (String)"signatureElementId", null);
    }

    public static boolean isETSI_119_132(IArgs args) {
        return ArgTools.getBoolStrict((IArgs)args, (String)"etsi_119132", (boolean)false);
    }

    private XMLSignerTools() {
    }
}

