/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.Transformation;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.XPathFilter2ParameterSpec;
import javax.xml.crypto.dsig.spec.XPathType;

public class XPath2Transformation
extends Transformation {
    static Map<String, XPathType.Filter> xPath2FilterLookup = new HashMap<String, XPathType.Filter>(3);
    public static final String ALGORITHM = "http://www.w3.org/2002/06/xmldsig-filter2";

    public XPath2Transformation() {
    }

    public XPath2Transformation(String filter, String expression) {
        super(filter, expression);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public Transform toTransform(XMLSignatureContainerBuilder xmlSigner, DOMSignContext context) throws InvalidAlgorithmParameterException {
        String nsPrefix = context.getParent().lookupPrefix(ALGORITHM);
        context.putNamespacePrefix(ALGORITHM, (nsPrefix = context.getNamespacePrefix(ALGORITHM, nsPrefix)) == null ? "xf" : nsPrefix);
        try {
            XPathType.Filter xpath2filter = xPath2FilterLookup.get(this.getFilter());
            XPathType xpathType = new XPathType(this.getExpression(), xpath2filter, Collections.emptyMap());
            XPathFilter2ParameterSpec xpath2Para = new XPathFilter2ParameterSpec(Collections.singletonList(xpathType));
            return xmlSigner.getSignatureFactory().newTransform(this.getAlgorithm(), xpath2Para);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException(e.getLocalizedMessage(), e);
        }
    }

    static {
        xPath2FilterLookup.put("intersect", XPathType.Filter.INTERSECT);
        xPath2FilterLookup.put("subtract", XPathType.Filter.SUBTRACT);
        xPath2FilterLookup.put("union", XPathType.Filter.UNION);
    }
}

