/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.signature;

import de.intarsys.security.method.xml.signature.Transformation;
import de.intarsys.security.method.xml.signature.XMLSignatureContainerBuilder;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.util.Collections;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.spec.XPathFilterParameterSpec;

public class XPathTransformation
extends Transformation {
    public static final String ALGORITHM = "http://www.w3.org/TR/1999/REC-xpath-19991116";

    public XPathTransformation() {
    }

    public XPathTransformation(String expression) {
        super(null, expression);
    }

    @Override
    public String getAlgorithm() {
        return ALGORITHM;
    }

    @Override
    public Transform toTransform(XMLSignatureContainerBuilder xmlSigner, DOMSignContext context) throws InvalidAlgorithmParameterException {
        try {
            XPathFilterParameterSpec xpathPara = new XPathFilterParameterSpec(this.getExpression(), Collections.emptyMap());
            return xmlSigner.getSignatureFactory().newTransform(this.getAlgorithm(), xpathPara);
        }
        catch (NoSuchAlgorithmException e) {
            throw new InvalidAlgorithmParameterException(e.getLocalizedMessage(), e);
        }
    }
}

