/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.security.method.xml.spec;

import de.intarsys.tools.documentation.Specification;
import de.intarsys.tools.dom.DOMTools;
import de.intarsys.tools.string.StringTools;
import java.util.function.Supplier;
import org.etsi.uri._01903.v1_3.ObjectFactory;
import org.w3c.dom.Element;

public final class XAdESBaseline {
    @Specification(title="ETSI_EN_319_132_1", description="XAdES digital signatures; Part 1: Building blocks and XAdES baseline signatures", link="https://www.etsi.org/deliver/etsi_en/319100_319199/31913201/")
    public static final String SPEC = "ETSI_EN_319_132_1";
    public static final String XMLNS_132_PREFIX = "xades132";
    public static final String XMLNS_132 = "http://uri.etsi.org/01903/v1.3.2#";
    public static final ObjectFactory OF_1_3 = new ObjectFactory();
    public static final String XMLNS_141_PREFIX = "xades141";
    public static final String XMLNS_141 = "http://uri.etsi.org/01903/v1.4.1#";
    public static final org.etsi.uri._01903.v1_4.ObjectFactory OF_1_4 = new org.etsi.uri._01903.v1_4.ObjectFactory();
    public static final String EL_QUALIFYING_PROPERTIES = "QualifyingProperties";
    public static final String EL_SIGNED_PROPERTIES = "SignedProperties";
    public static final String EL_SIGNED_SIGNATURE_PROPERTIES = "SignedSignatureProperties";
    public static final String EL_SIGNED_DATA_OBJECT_PROPERTIES = "SignedDataObjectProperties";
    public static final String EL_UNSIGNED_PROPERTIES = "UnsignedProperties";
    public static final String EL_UNSIGNED_SIGNATURE_PROPERTIES = "UnsignedSignatureProperties";
    public static final String EL_UNSIGNED_DATA_OBJECT_PROPERTIES = "UnsignedDataObjectProperties";
    public static final String ATTR_TARGET = "Target";
    public static final String ATTR_ID = "Id";
    public static final String EL_SIGNATURE_TIME_STAMP = "SignatureTimeStamp";
    public static final String EL_SIGNATURE_VALUE = "SignatureValue";
    public static final String EL_SIGNATURE = "Signature";
    public static final String EL_SIGNING_CERTIFICATE_V2 = "SigningCertificateV2";
    public static final String EL_CERT = "Cert";
    public static final String EL_CERT_DIGEST = "CertDigest";
    public static final String ATTR_ENCODING = "Encoding";
    public static final String ATTR_ENCODING_VALUE_DER = "http://uri.etsi.org/01903/v1.2.2#DER";
    public static final String EL_ALL_SIGNED_DATA_OBJECTS = "AllSignedDataObjects";
    public static final String EL_COMMITMENT_TYPE_ID = "CommitmentTypeId";
    public static final String EL_COMMITMENT_TYPE_INDICATION = "CommitmentTypeIndication";
    public static final String EL_SIG_POLICY_QUALIFIER = "SigPolicyQualifier";
    public static final String EL_SIG_POLICY_QUALIFIERS = "SigPolicyQualifiers";
    public static final String EL_SIG_POLICY_ID = "SigPolicyId";
    public static final String EL_SIGNATURE_POLICY_ID = "SignaturePolicyId";
    public static final String EL_CERTIFIED_ROLES = "CertifiedRoles";
    public static final String EL_SIGNER_ROLE = "SignerRole";
    public static final String EL_SIGNATURE_POLICY_IMPLIED = "SignaturePolicyImplied";
    public static final String EL_SIGNATURE_POLICY_IDENTIFIER = "SignaturePolicyIdentifier";
    public static final String EL_SIG_POLICY_HASH = "SigPolicyHash";
    public static final String EL_X509_ATTRIBUTE_CERTIFICATE = "X509AttributeCertificate";
    public static final String EL_CERTIFIED_ROLE = "CertifiedRole";
    public static final String EL_CERTIFIED_ROLES_V2 = "CertifiedRolesV2";
    public static final String EL_SIGNER_ROLE_V2 = "SignerRoleV2";
    public static final String EL_SIGNING_CERTIFICATE = "SigningCertificate";

    protected static Supplier<Element> getExistingSupplier(final Supplier<Element> parentSupplier, final String localName) {
        return new Supplier<Element>(){
            Element properties = null;

            @Override
            public Element get() {
                if (this.properties == null) {
                    this.properties = (Element)((Element)parentSupplier.get()).getElementsByTagNameNS(XAdESBaseline.XMLNS_132, localName).item(0);
                }
                return this.properties;
            }
        };
    }

    protected static Supplier<Element> getLazySupplier(final Supplier<Element> parentSupplier, final String localName, final String id) {
        return new Supplier<Element>(){
            Element properties = null;

            @Override
            public Element get() {
                if (this.properties == null) {
                    Element parent;
                    String prefix = (parent = (Element)parentSupplier.get()).lookupPrefix(XAdESBaseline.XMLNS_132);
                    this.properties = DOMTools.getOrCreateChild((Element)parent, (String)XAdESBaseline.XMLNS_132, (String)(prefix == null ? XAdESBaseline.XMLNS_132_PREFIX : prefix), (String)localName);
                    if (!StringTools.isEmpty((String)id)) {
                        DOMTools.setIdAttribute((Element)this.properties, (String)XAdESBaseline.ATTR_ID, (String)id);
                    }
                }
                return this.properties;
            }
        };
    }

    public static Supplier<Element> getQualifyingPropertiesSupplier(Supplier<Element> parentSupplier) {
        return XAdESBaseline.getExistingSupplier(parentSupplier, EL_QUALIFYING_PROPERTIES);
    }

    public static Supplier<Element> getSignedDataObjectPropertiesSupplier(Supplier<Element> parentSupplier, String id) {
        return XAdESBaseline.getLazySupplier(parentSupplier, EL_SIGNED_DATA_OBJECT_PROPERTIES, id);
    }

    public static Supplier<Element> getSignedPropertiesSupplier(Supplier<Element> parentSupplier, String id) {
        return XAdESBaseline.getLazySupplier(parentSupplier, EL_SIGNED_PROPERTIES, id);
    }

    public static Supplier<Element> getSignedSignaturePropertiesSupplier(Supplier<Element> parentSupplier, String id) {
        return XAdESBaseline.getLazySupplier(parentSupplier, EL_SIGNED_SIGNATURE_PROPERTIES, id);
    }

    public static Supplier<Element> getUnsignedDataObjectPropertiesSupplier(Supplier<Element> parentSupplier, String id) {
        return XAdESBaseline.getLazySupplier(parentSupplier, EL_UNSIGNED_DATA_OBJECT_PROPERTIES, id);
    }

    public static Supplier<Element> getUnsignedPropertiesSupplier(Supplier<Element> parentSupplier, String id) {
        return XAdESBaseline.getLazySupplier(parentSupplier, EL_UNSIGNED_PROPERTIES, id);
    }

    public static Supplier<Element> getUnsignedSignaturePropertiesSupplier(Supplier<Element> parentSupplier, String id) {
        return XAdESBaseline.getLazySupplier(parentSupplier, EL_UNSIGNED_SIGNATURE_PROPERTIES, id);
    }

    private XAdESBaseline() {
    }
}

